;+
; NAME:
;	XSH_PYTHON
;
; PURPOSE:
;	Runs a python script from IDL 
;
; CATEGORY:
;	SHADOW
;
; CALLING SEQUENCE:
; 
;	xsh_python,'script_name'
;
; INPUTS:
;	script_name:	The python script (including path, if necessary)
;
; KEYWORD PARAMETERS:
;       init: the  initialization script (default: 
;             $XOP_HOME/extensions/shadowvui/shadow3/setpythonpath' 
;       script_dir: name of the directory containing the script (ended with
;              directory separator) Default='' 
;       phython_name: name of the python binary (including path, if needed)
;              Default='python'
;
; OUTPUTS:
;	creates a C-shell script (called xsh_python.sh) and runs it 
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;
;		xsh_python   ; (runs: python -c "import Shadow")
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio, srio@esrf.eu 2013/12/20
;
;-

pro xsh_python,script_name, init=init, script_dir=script_dir, $
               phython_name=python_name

on_error,2


if n_elements(script_name) EQ 0 then script_name='-c "import Shadow"'
if n_elements(init) EQ 0 then begin
    ds=sdep(/ds)
    shadow3_root = XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+ $
                   'shadowvui'+ds+'shadow3'
    init='. '+shadow3_root+'/setpythonpath.sh init'
endif
if n_elements(script_dir) EQ 0 then script_dir=''
if n_elements(python_name) EQ 0 then python_name='python'

openw,unit,'xsh_python.sh',/get_lun
printf,unit,init
printf,unit,python_name+' '+script_dir+script_name
free_lun,unit

command='./xsh_python.sh'
print,'Executing :  '+command
spawn,'chmod +x xsh_python.sh'
spawn,command
print,'Done executing :  '+command

end
