Function  xsh_f0,str,Group=group,iask=iask,load=load
common xsh_f0, wk_names, wk_data
;
; calculates the f0 values needed to run bragg.
; Used internally by xsh_bragg
; srio@esrf.fr 97/12/15
;
; 98/03/20 srio@esrf.fr adds the load kw. When set, it just restores the
; file (if needed) and puts it in the common block. It does not
; perform any operation. Useful for creating shadow.sav
;
; 98/04/17 fixed two bug when calculating f0(ratio)
; 01/03/14 fixed a bug when using As or other elements with a single
;	entry in the f0 table.  Vittiglio Guido <GVittiglio@spectro-ai.com>
;
; 2012-05-04 srio@esrf.eu bug fixed with RockSalt structure
;                  (noticed by Frank.Filsinger@bruker-axs.de) 
;
on_error,2

IF NOT(keyword_set(load)) THEN BEGIN
  structure=fix(str.structure(0))
  a_lattice = str.Lattice_Cte_a
  c_lattice = str.Lattice_Cte_c
  h_miller = float(str.h_miller_index)
  k_miller = float(str.k_miller_index)
  l_miller = float(str.l_miller_index)

  if n_elements(iask) EQ 0 then iask=0
  if structure EQ 0 or structure EQ 1 or structure EQ 3 then n_el=2 else n_el=1
  elements = [str.Symbol_1st,str.Symbol_2nd]

  if structure GE 0 and structure LE 3 then begin
    d_space = a_lattice/(sqrt(h_miller^2+k_miller^2+l_miller^2))
    one_over_2d = 1.0/2.0/d_space
  endif else begin

    one_over_d_space2 = (4.0/3.0)*( $
       ( (h_miller^2+k_miller^2+h_miller*k_miller)/a_lattice^2 ) + $
       ( (3*l_miller^2)/4/c_lattice^2 )   )
    one_over_2d = sqrt(one_over_d_space2)/2.0
  endelse
ENDIF
;
; restore data 
;
if n_elements(wk_data) EQ 0 then begin
  restorefile = filepath1('f0_wk.xdr')+sdep(/ds)+'f0_wk.xdr'
  if checkfile(restorefile) NE 1 then begin
    itmp = Dialog_Message(Dialog_Parent=group,/Question,$
  	'File '+restorefile+' not found. Load it?')
    restorefile = ''
    if itmp EQ 'Yes' then restorefile=Dialog_Pickfile($
  	Title='Read File with F0 values...')
    if restorefile EQ '' then begin
      itmp = Dialog_Message(Dialog_Parent=group,/Error,$
	  'File with F0 undefined. bragg not run.')
      return,0
    endif
  endif
  wk_names = '' & wk_data = 0
  message,/info,$
  'Reading file with F0 table (Waasmaier&Kirfel, Acta Cryst, 1995, A51 416)...'
  restore,/verbose,restorefile
  message,/info,'Done.'
endif
IF keyword_set(LOAD) then return,0
;
; get coeffs
;
f0_coeff = fltarr(2,11)
for i=0,n_el-1 do begin
  el1 = elements(i)
  igood = where(strpos(wk_names,el1) NE -1)
    if igood[0] EQ -1 then begin
      itmp = Dialog_Message(Dialog_Parent=group,/Error,$
  	'Element not found ('+el1+') in F0 table. Bragg did not run.')
      return,0
    endif
  if iask then $
    itmp = wmenu2(wk_names(igood)) else $
    itmp = 0
  f0_coeff(i,*) = wk_data(igood(itmp),*)
endfor
;
; calculate outputs
;
xout = [one_over_2d-0.1,one_over_2d,one_over_2d+0.1]
yout = fltarr(2,3)
for j=0,n_el-1 do begin
  f0 = f0_coeff(j,5)
  for i=0,5-1 do f0 = f0 + f0_coeff(j,i) * exp(-1.0d0*f0_coeff(j,i+5+1)*xout^2)
  yout(j,*) = f0
endfor

out = fltarr(n_el+1,3)
out(0,*) = xout
out(1,*) = yout(0,*)
if n_el eq 2 then out(2,*) = yout(1,*)
return,out

end

