;+
;
; FUNCTION vectrans,vector
;
; Written by D. Bianchi, ESRF, 2006
;
;//
;// Function Name:
;//
;//   vectrans - Transformation matrix for a translation.
;//
;// Calling Sequence:
;//
;//   st = vectrans(tvec)
;//
;// Parameters:
;//
;//   tvec  : A vectors defining the translation along the x,y and
;//                   z axes. i.e. [tx, ty, ty]
;//
;//   st       : Translation Transformation Matrix
;//
;// Description:
;//
;//   Returns a (4x4) Transformation matrix for translation.
;//
;//   The matrix is:
;//
;//         [ 1   0   0   tx ]
;//         [ 0   0   0   ty ]
;//         [ 0   0   0   tz ]
;//         [ 0   0   0   1  ]
;//
;-

FUNCTION vectrans,vector
dd = [[1,0,0,vector[0]],[0,1,0,vector[1]],[0, 0, 1, vector[2]],[ 0, 0, 0, 1]]

return, dd

END
