;+
;
; FUNCTION vecproduct, v1,v2, normalized = normalized
;
; INPUT
; V1, V2 = R3 direction vector
; OUTPUT
; V = vector product between V1 and V2
;
; normalized flag set to 1 by default!!!!!
;
; Written by D. Bianchi, ESRF, 2006
;-

FUNCTION vecproduct, v1,v2, normalized = normalized

v=[ v1[1,*]*v2[2,*] - v1[2,*]*v2[1,*] , -(v1[0,*]*v2[2,*] - v1[2,*]*v2[0,*]) , v1[0,*]*v2[1,*] - v1[1,*]*v2[0,*] ]

IF N_Elements(normalized) EQ 0 THEN normalized=1

IF normalized THEN BEGIN
  det=sqrt(total(v*v,1))
  ;print, det
  v[0,*]/=det
  v[1,*]/=det
  v[2,*]/=det
ENDIF

return,v

END
