FUNCTION nrbpipes


;curve variables
n=30
a=0.
b=100.;2*!dpi
c=100.
set=nrblinear(a,b*(n+1)/(n-1),n+2)
x=set
y=5*(cos(2*!dpi*x/c) - 1.)
;curve plot

;numerical derivative at all y points
der1=deriv(x,y)
;plot of the derivative

;radius of the sections of the pipe

rr=abs(nrblinear(-10,-4,n));replicate(100,n);

;1st section
crf=nrbcirc(rr[0],oo=fltarr(3))

ry=vecroty(90,/deg)
rz=vecrotz(atan(der1[0]))

;orientaion of the first pipe section
crf=nrbtransform(crf,rz##ry)

;fisrt section of the surface
f=[crf.coefs]


;nrbplot,crf,10



FOR i=1,n-1 DO BEGIN

;rotation of the section with respect of the derivative of the function y(x)
ang=atan(der1[i])
;x-y centred circle with radius rr[i]
d=nrbcirc(rr[i])

;matrix of translation in the position of the y(x[i])
trans=vectrans([x[i],y[i],0.])
;rotation around z axis of an angle ANG
rz=vecrotz(ang)

;total matrix of transformation
tr=trans##rz##ry

;reshape of the section
d=nrbtransform(d,tr)

;coefficient of the extruded surface
f=[[[f]],[[d.coefs]]]

ENDFOR

dim=size(f,/dimensions)
;degrees of the nurbs
p=3
q=3

;knots
v=nrblinear(0,1,dim[2]-q+1)
vknots=[0,0,0,v,1,1,1]
;pipe structure
pipes=nrbstruct(f,d.uknots,vknots)

;rotation for direction along y direction
rz=vecrotz(!dpi/2);
pipes=nrbtransform(pipes,rz)

;drawing of surface
nrbplot,pipes,100,100

return,pipes


END

