;+
;
; FUNCTION nrbmakesphere,rr,p=p,q=q,angle=angle,ll=ll, ww=ww
;
; ARGUMENTS
;
;   RR = sphere's radius [if undefined, calculate from P,Q,Angle] 
;   P  = distance source-mirror
;   Q  = distance mirror-image
;   ANGLE  = Grazing incident angle [rad]
;   LL = spherical aperture (chord, default = 10)
;   WW = spherical aperture (chord, default = 5)
;
; OUTPUT
;
;   MIRR = a NURBS structure of a spherical dome, minimum centred on 
;          the axis' origin
;-

FUNCTION nrbmakesphere,rr,p=p,q=q,angle=angle,ll=ll, ww=ww

IF n_elements(rr) EQ 0 THEN BEGIN
	IF n_elements(p) EQ 0 THEN p=3000
	IF n_elements(q) EQ 0 THEN q=1000
	IF n_elements(angle) EQ 0 THEN angle=5e-3
	rr = 2D0*p*q/(p+q)/sin(angle)
ENDIF

IF n_elements(ll) EQ 0 THEN ll = 10
IF n_elements(ww) EQ 0 THEN ww = 5

rr=double(rr)
ll=double(ll)
ww=double(ww)

alpha_ll = asin(ll/2d/rr) ;semiangular aperture of the mirror for the length of the mirror

alpha_s = !dpi - alpha_ll ;start angle (see __nrbcirc.pro)
alpha_e = !dpi + alpha_ll ;end angle (see __nrbcirc.pro)
alpha_ww= asin(ww/2/rr) ;angular aperture of the mirror for the length of the mirror

;structure of the arc of circumference x-y system
crf = __nrbcirc(rr,oo=[0d,0d,0d],sang=alpha_s,eang=alpha_e) 

sph = __nrbrevolve(crf,pnt=[0d,0d,0d],vec=[0d,-1d,0d],theta=2*alpha_ww)


;matx = vecrotx(!dpi/2) ;rotation around the x axis
matz = vecrotz(!dpi/2)
maty = vecroty(-atan(1d/tan(alpha_ww)))
matrans = vectrans([rr*cos(alpha_ww),0d,rr*sin(alpha_ww)])
sph=nrbtransform(sph,maty##matrans) ;new arc structure in x-z systemmatz##


return, sph


END
