;
; FUNCTION NAME
;   __NRBCTRLPOLYMAT
; AIM:
;   calculus of the NURBS control polygon matrix (way to semplify calculus by matrix reducing loops)
; ARGUMENTS:
;   PARAMENTRIC = array of parametric points
;   KNOTS = knots array (look to interpknots.pro function)
;   DEG = degree of the basis function
;   DIM = number of point along the space dimension
; OUTPUT:
;   R = matrix of basis function with all the Ni elements on the row for every parametric point
;

FUNCTION __nrbctrlpolymat, parametric, knots, deg, dim

npar=n_elements(parametric)
R=dblarr(dim,npar)
FOR jj = 0,npar-1 DO BEGIN
    s=__nrbfindspan(dim-1,deg,parametric[jj],knots)
    N=__nrbbasisfun(s,parametric[jj],deg,knots)
    R(s-deg:s,jj) = N[*]
ENDFOR
return, R
END
