;
; INTERNAL FUNCTION __nrbBasisFun()
;
; Basis Function.
;
; INPUT:
;   i - knot span  ( from __nrbFindSpan() )
;   u - parametric point
;   p - spline degree
;   knots - knot sequence
;   nu - nuber of knots
; OUTPUT:
;   N - Basis functions vector[p+1]
;
; Algorithm A2.2 from 'The NURBS BOOK' pg70.
;

FUNCTION __nrbbasisfun,i,u,p,knots

left = dblarr(p+1)
right = dblarr(p+1)
N=dblarr(p+1) ;/*span of non-zeros basis function*/


;/*generation of N[i] basis function, by algorithm (NURBS BOOK)*/
N[0] = 1.0

FOR j=1,p DO BEGIN

    left[j]  = u - knots[i+1-j]
    right[j] = knots[i+j] - u
    saved = 0.0

    FOR r = 0,j-1 DO BEGIN
      temp = N[r] / (right[r+1] + left[j-r])
      N[r] = saved + right[r+1] * temp
      saved = left[j-r] * temp
    ENDFOR

    N[j] = saved

ENDFOR

return,N

END
