;+
; NAME:
;       GET_RGB
;
; PURPOSE:
;       This function allows to setect a RGB color 
;
; CATEGORY:
;       WIDGET
;
; CALLING SEQUENCE:
;       rgb=GET_RGB, Parent, rgb=rgb.
;
; INPUTS:
;		Parent: a widget_base
;
; KEYWORD PARAMETERS:
;		rgb: the default rgb color.
;
; OUTPUTS: an IDL structure with the following tags: 
;  	OK (1 means Accept button was pressed. 0 for Cancel)
;	RGB a 3-dim INT array with the Red, Green and Blue indices
;
; EXAMPLE:
;		oldrgb=[0,0,255] ;blue
;		newrgb=GET_RGB(oldrgb)
;
; PROCEDURE:
;	It uses CW_RGBSLIDER
;
; MODIFICATION HISTORY:
;       Written by:  M. Sanchez del Rio, ESRF 2001/10/03
;	Modification history: 
;	
;-

PRO Get_RGB_event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'Get_RGB_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


Widget_Control, event.top, get_uvalue=info
flag_Destroy=0
CASE Tag_Names(event,/Structure_Name) OF 
	'RGB_EVENT': (*(info.ptr)).rgb=[event.r,event.g,event.b]
	'WIDGET_BUTTON': BEGIN
		Widget_Control,event.id,Get_Value=value
		CASE value OF
		  'Accept': (*(info.ptr)).ok=1
		  'Cancel': (*(info.ptr)).ok=0
		  else: 
		ENDCASE
		flag_Destroy=1
		END
	'WIDGET_KILL_REQUEST': BEGIN
		(*(info.ptr)).ok=0
		flag_Destroy=1
		END
	else: 
ENDCASE
Widget_Control, event.top, Set_UValue=info
IF flag_Destroy EQ 1 THEN widget_control, event.top, /destroy
RETURN
END

;
;===============================================================================
;


FUNCTION Get_RGB, parent, rgb=rgb, Title=title

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'Get_RGB: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


IF Float(!version.release) LT 5.4 THEN BEGIN
   Return,Set_Color(parent,  rgb=rgb, Title=title)
ENDIF


if N_elements(rgb) eq 0 then rgb=[0,0,0]
if N_elements(title) eq 0 then title="RGB Colors"

IF N_Elements(parent) NE 0  THEN $
  base=widget_base(GROUP_LEADER=parent,/floating,/col,title=title,/modal,/TLB_Kill_Request_Events) ELSE $
  base=widget_base(/col,title=title,/TLB_Kill_Request_Events)

menu_fin=widget_base(base,/row)
	ok=widget_button(menu_fin,value='Accept')
	cancel=widget_button(menu_fin,value='Cancel')

wtmp = CW_RGBSlider(base,/Color_Index,Value=rgb)

widget_control, base, /realize

ptr=ptr_new({ok:0, rgb:rgb})
info={ptr:ptr}

widget_control, base, set_uvalue=info


xmanager,'Get_RGB', base

color_info=*ptr
ptr_free, ptr
RETURN, color_info

END
