;+
; NAME:
;       OPEN_optical_system_blv.
;
; PURPOSE:
;       This procedure reads all the information necessary to create an 
;		optical_module thanks to
;		files created by BLViewer
;
; CATEGORY:
;       BLViewer
;
; CALLING SEQUENCE:
;       OPEN_optical_system_blv, pInfo, file
;
; INPUTS:
;       pInfo:  A pointer on the blviewer uValue.
;		File: the name of a Sytemfile created by BLViewer (*.dat)
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;		OPEN_optical_system_blv, pInfo, file
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-
pro blv_open_optical_system_blv, pInfo, file, group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_open_optical_system_blv: error caught: '+!error_state.msg)
   RETURN
ENDIF


(*pInfo).data.last_file_name=file

;supp all actual element
oldSystem =(*pInfo).data.system
oldSystem->getProperty, dimension_scale=dimension_scale, $
								distance_scale=distance_scale, $
								show_axis=show_axis, $
								show_plane=show_plane, $
								show_symbol=show_symbol, $
								show_normal=show_normal, $
								show_axes_element=show_axes_element, $
								Log=log, $
								Transparen=transparen, $
								rays_style=rays_style, $
								rays_type_toDraw=rays_type_toDraw, $
								vector_sensitive_source=vector_sensitive_source, $
								vector_sensitive_element=vector_sensitive_element, $
								vector_sensitive_image=vector_sensitive_image, $
								optical_element_color=optical_element_color, $
								optical_axes_color=optical_axes_color, $
								optical_plane_color=optical_planecolor, $
								normal_color=normal_color, $
								normal_scale=normal_scale, $
								axes_element_scale=axes_element_scale, $
								axes_element_color=axes_element_color

obj_destroy, oldSystem

(*pInfo).data.position=-1

newSystem = read_blv_format(file,Group=group)
newSystem->setProperty, dimension_scale=dimension_scale, $
								distance_scale=distance_scale, $
								show_axis=show_axis, $
								show_plane=show_plane, $
								show_symbol=show_symbol, $
								show_normal=show_normal, $
								show_axes_element=show_axes_element, $
								Log=log, $
								Transparen=transparen, $
								rays_style=rays_style, $
								rays_type_toDraw=rays_type_toDraw, $
								vector_sensitive_source=vector_sensitive_source, $
								vector_sensitive_element=vector_sensitive_element, $
								vector_sensitive_image=vector_sensitive_image, $
								optical_element_color=optical_element_color, $
								optical_axes_color=optical_axes_color, $
								optical_plane_color=optical_plane_color, $
								normal_color=normal_color, $
								normal_scale=normal_scale, $
								axes_element_scale=axes_element_scale, $
								axes_element_color=axes_element_color

(*pInfo).data.system=newSystem
newSystem->getProperty, omodel=omodel
(*pInfo).wid.model->add, omodel
(*pInfo).data.position=(*pInfo).data.system->count()-1
;blv_show_element, pInfo

end
