;
; PRO blv_export_image
;
; purpose: Make a copy of current representation and show it as an image. 
; It's possible to save it in a standard format
;
; Input: image (an object of the type IdlGrImage)
; Optional input: scr_size (2-dim array with screen dimensions )
; Keywords: Title (string), Group_Leader (Long with parent widget id)
;
; 
; Written by Cyril Poirier, ESRF,  2001 
; Modified: 
;	srio 2001/10/02
;
;

;
;===============================================================================
;
pro blv_export_image_save, event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_export_image_save: error caught: '+!error_state.msg)
   RETURN
ENDIF


	forward_function DIALOG_WRITE_IMAGE
	widget_control, event.top, get_uvalue=pInfo
	(*pInfo).image->getProperty, data=imageData

		IF Float(!version.release) LE 5.2 THEN BEGIN
		  file=dialog_pickfile(title='Open JPEG Image...', Filter='*.jpg', $
					/Write, DIALOG_PARENT=(*pInfo).Base)
		  IF file EQ '' THEN RETURN
		  Write_jpeg,file,imageData,True=1
		  ;itmp = Dialog_Message(/Info, $
		  ;'Sorry: Option not implemented in the current version of IDL : '+$
		  ;              !version.release)
		ENDIF ELSE BEGIN
		   Result = DIALOG_WRITE_IMAGE (imageData,DIALOG_PARENT=(*pInfo).Base)
		ENDELSE


	;IF Float(!version.release) LE 5.2 THEN BEGIN
	;  itmp = Dialog_Message(/Info, $
	;    'Sorry: Option not implemented in the current version of IDL : '+$
	;	!version.release)
	;ENDIF ELSE BEGIN
	;  Result = DIALOG_WRITE_IMAGE (imageData ,DIALOG_PARENT=(*pInfo).base)
	;ENDELSE
end ; blv_export_image_save

;
;===============================================================================
;
pro blv_export_image_draw_event, event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_export_image_draw_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


 	widget_control, event.top, get_uvalue=pInfo
	(*pInfo).window->draw, (*pInfo).oview
end ; blv_export_image_draw_event

;
;===============================================================================
;
pro blv_export_image_quit, event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_export_image_quit: error caught: '+!error_state.msg)
   RETURN
ENDIF



	widget_control, event.top, get_uvalue=pInfo
	obj_destroy, (*pInfo).image
	obj_destroy, (*pInfo).window
	base=(*pInfo).base
	ptr_free, pInfo
	widget_control, base, /destroy
end ; blv_export_image_quit

;
;===============================================================================
;
pro blv_export_image, image, screen, Title=title, Group_Leader=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_export_image: error caught: '+!error_state.msg)
   RETURN
ENDIF


	IF N_Elements(screen) NE 2 THEN screen = [700,600]
	IF N_Elements(title) EQ 0 THEN title = 'Grabbed image from BlViewer'
	base=widget_base(GROUP_LEADER=group,title=title,/col,  $
			 /floating,mbar=bar,/TLB_KILL_REQUEST_EVENTS, $
			event_pro='blv_export_image_quit')

	wFile=widget_button(bar,value='File',/menu)
	  wTmp=widget_button(wFile,value='Save As...',$
			event_pro='blv_export_image_save')
	wdraw=widget_draw(base,xsize=screen[0],ysize=screen[1], $
		GRAPHICS_LEVEL=2, /EXPOSE, $
		event_pro='blv_export_image_draw_event')
	wTmp=widget_button(wFile,value='Quit',event_pro='blv_export_image_quit')

	widget_control, base, /realize
	;graphics' items
	omodel=obj_new('idlgrmodel', name='Model')
	oview=obj_new('idlgrview',color=[100,100,100],PROJECTION=1, $
		VIEWPLAN=[0,0,1,1])
	oview->add, omodel
	widget_control, wdraw, get_value=window
	omodel->add, image
	window->draw, oview
	pInfo=ptr_new({ base:base, $
			window:window, $
			image:image, $
			oview:oview $
			})
	widget_control, base, set_uvalue=pInfo
	xmanager, 'BLV_export_image', base, /no_block
end
