function nrbdeval,nrb, uu,vv,jacob=jacob,dnrb=dnrb
;// Evaluation of the derivative NURBS curve or surface.
;//
;//     [pnt, jac] = nrbdeval(crv, dcrv, tt)
;//     [pnt, jac] = nrbdeval(srf, dsrf, {tu tv})
;//
;// INPUTS:
;//
;//   crv    - original NURBS curve.
;//
;//   srf    - original NUBRS surface
;//
;//   dcrv   - NURBS derivative represention of crv
;//
;//   dsrf   - NURBS derivative represention of surface
;//
;//   tt     - parametric evaluation points
;//            If the nrb is a surface then tt is a cell
;//            {tu, tv} are the parametric coordinates
;//
;//   pnt  - evaluated points.
;//   jac  - evaluated first derivatives (Jacobian).
;//
;// Examples:
;//
;//   // Determine the first derivatives a NURBS curve at 9 points for 0.0 to
;//   // 1.0
;//   tt = linspace(0.0, 1.0, 9);
;//   dcrv = nrbderiv(crv);
;//   [pnts,jac] = nrbdeval(crv, dcrv, tt);

;//  D.M. Spink
;//  Copyright (c) 2000.

IF size(nrb,/Type) NE 8 THEN BEGIN
    message,'NURBS representation is not structure!'
ENDIF

np=n_params()

IF n_elements(nrb.dim) EQ 1 and np GE 3 THEN BEGIN

    message,'to many argouments for a curve NURBS'

ENDIF

IF n_elements(nrb.dim) EQ 2 and np LT 3 THEN BEGIN

    message,'it missess or the U vector or the V vector'

ENDIF
;if ~strcmp(nrb.form,'B-NURBS')
;  error('Not a recognised NURBS representation');
;end

IF np EQ 3 THEN BEGIN

p = nrbeval(nrb, uu,vv,w=cw,/space) ; CW: Coefficient Weights

  temp = dblarr(size(p,/dimensions))
  temp(*,0,*) = cw
  temp(*,1,*) = cw
  temp(*,2,*) = cw

  pnt=p/temp

IF keyword_set(dnrb) THEN BEGIN

  ;// NURBS structure represents a surface

  der=nrbderstruct(nrb)

  dpu = nrbeval(der.deru,uu,vv,w=dcwu,/space) ;DCWU: Derivative Coefficients Weights along U
                                              ;DPU: Derivative evalueted Points along U
  tempu = dblarr(size(dpu,/dimensions))
  tempu(*,0,*) = dcwu
  tempu(*,1,*) = dcwu
  tempu(*,2,*) = dcwu

jacu = (dpu-tempu*pnt)/temp;
  dpv = nrbeval(der.derv,uu,vv,w=dcwv,/space) ;DCWU: Derivative Coefficients Weights along V
                                              ;DPU: Derivative evalueted Points along U
  tempv = dblarr(size(dpv,/dimensions))
  tempv(*,0,*) = dcwv
  tempv(*,1,*) = dcwv
  tempv(*,2,*) = dcwv

  jacv = (dpv-tempv*pnt)/temp;
  jacob={jacu:jacu,jacv:jacv}

ENDIF
ENDIF ELSE BEGIN

p = nrbeval(nrb, uu,w=cw,/space)

  temp = dblarr(size(p,/dimensions))
  temp(*,0,*) = cw
  temp(*,1,*) = cw
  temp(*,2,*) = cw

  pnt=p/temp

IF keyword_set(dnrb) THEN BEGIN

  der=nrbderstruct(nrb)

  dpu = nrbeval(der.deru,uu,w=dcwu,/space)

  tempu = dblarr(size(dpu,/dimensions))
  tempu(*,0,*) = dcwu
  tempu(*,1,*) = dcwu
  tempu(*,2,*) = dcwu

  jacu = (dpu-tempu*pnt)/temp

jacob={jacu:jacu}

ENDIF
ENDELSE

return, pnt

END