FUNCTION int_check, patch, plane,dist=dist,allpatches=allpatches

;+
;
; FUNCTION int_check, patch, plane,dist=dist,allpatches=allpatches
;
; Returns the patches that intersect the rays (defined as planes)
; 
; 
; Inputs: 
;         patch: the array of patches
;         plane: the rays
;
; Outputs: 
;        Returned value: matrix (npatches,nrays) with flags: 1=intersect, 0=no
;           The check is done until an intersection with a patch occurs. 
;
; Keywords: 
;        AllPatches: set this flag to force the code to chech all
;	 patches for intersection. By default (allPatches=0) the program returns
;	 after finding one intersection. (not tested)
;
;-  

nbzr = n_elements(patch)

np = n_elements(plane)

dcheck = uintarr(nbzr,np)


IF Not(Keyword_Set(allPatches)) THEN BEGIN
  jj = -1
  FOR ii=0L,np-1 DO BEGIN
    ;=== searchs intersection patches ===;
    ;each ray (rows) with every patch (columns) in case of multiple intersection
    REPEAT BEGIN
      jj++
      dist = distgrid(plane[ii],patch[jj])
      dcheck[jj,ii] = containsorigin(dist.xgrid,dist.ygrid)
    ENDREP UNTIL ((dcheck[jj,ii] EQ 1) OR (jj EQ nbzr-1))
  jj=-1
  ENDFOR
ENDIF ELSE BEGIN
  dist=replicate(distgrid(plane[0],patch[0]),nbzr,np)
  FOR ii=0L,np-1 DO BEGIN
    ;=== searchs intersection patches ===;
    ;each ray (rows) with every patch (columns) in case of multiple intersection
    FOR jj=0,nbzr-1 DO BEGIN ; REPEAT BEGIN
      tmp = distgrid(plane[ii],patch[jj])
      dist[jj,ii] = tmp
      dcheck[jj,ii] = containsorigin(dist.xgrid,dist.ygrid)
    ENDFOR ; ENDREP UNTIL ((dcheck[jj,ii] EQ 1) OR (jj EQ nbzr-1))
  ENDFOR
ENDELSE


return, dcheck

END
