;+
; NAME:
;       blv_source_control
;
; PURPOSE:
;       This function creates and returns a widget base with all the 
;	widget element necessary to control the property of the source.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;		wBase=blv_source_control, pInfo
;
; INPUTS:
;       pInfo: A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-



;
;===========================================================================================
;
;purpose : to close the widget
pro blv_source_control_close, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_source_control_close: error caught: '+!error_state.msg)
   RETURN
ENDIF


	temp=(*pInfo).wid.wSource
	(*pInfo).wid.wSource=(*pInfo).wid.tbl

	widget_control, temp, /destroy
end

;
;===========================================================================================
;
pro blv_source_control_addmesh, model, file, x, y, z
;purpose : to add a mesh at the good place

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_source_control_addmesh: error caught: '+!error_state.msg)
   RETURN
ENDIF


	newmodel=read_vrml_file(file)
	newmodel->translate, x, y, z
	model->add, newmodel
end

;
;===========================================================================================
;
pro blv_source_control_repeatMesh, info

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_source_control_repeatMesh: error caught: '+!error_state.msg)
   RETURN
ENDIF


source=(*info.pInfo).data.system->get_source()
source->getProperty, mesh_file=file
if strcmp(file,'Undefined') then return

widget_control, /HOURGLASS
widget_control, (*info.pInfoSource).wXpas, get_value=Xpas
widget_control, (*info.pInfoSource).wXmin, get_value=Xmin
widget_control, (*info.pInfoSource).wXmax, get_value=Xmax
widget_control, (*info.pInfoSource).wYpas, get_value=Ypas
widget_control, (*info.pInfoSource).wYmin, get_value=Ymin
widget_control, (*info.pInfoSource).wYmax, get_value=Ymax
widget_control, (*info.pInfoSource).wZpas, get_value=Zpas
widget_control, (*info.pInfoSource).wZmin, get_value=Zmin
widget_control, (*info.pInfoSource).wZmax, get_value=Zmax

model=obj_new('idlgrmodel')
if Xpas ne 0 then begin
for x=Xmin, Xmax, Xpas do begin
	if Ypas ne 0 then begin
		for y=Ymin, Ymax, Ypas do begin
			if Zpas ne 0 then begin
				for z=Zmin, Zmax, Zpas do begin
					blv_source_control_addmesh, model, file, x, y, z
				endfor
			endif else begin
			z=Zmin
			blv_source_control_addmesh, model, file, x, y, z
			endelse
		endfor
	endif else begin
			y=Ymin
					if Zpas ne 0 then begin
						for z=Zmin, Zmax, Zpas do begin
							newmodel=read_vrml_file(file)
							newmodel->translate, x,y,z
							blv_source_control_addmesh, model, file, x, y, z
						endfor
					endif else begin
						z=Zmin
						blv_source_control_addmesh, model, file, x, y, z
					endelse
				endelse
			endfor
		endif else begin
			x=Xmin
			if Ypas ne 0 then begin
					for y=Ymin, Ymax, Ypas do begin
						if Zpas ne 0 then begin
							for z=Zmin, Zmax, Zpas do begin
								blv_source_control_addmesh, model, file, x, y, z
							endfor
						endif else begin
							z=Zmin
							blv_source_control_addmesh, model, file, x, y, z
						endelse
					endfor
			endif else begin
					y=Ymin
					if Zpas ne 0 then begin
						for z=Zmin, Zmax, Zpas do begin
							blv_source_control_addmesh, model, file, x, y, z
						endfor
					endif else begin
						z=Zmin
						blv_source_control_addmesh, model, file, x, y, z
					endelse
			endelse
		endelse
		source->setProperty, symbol=model
blv_draw_system, info.pInfo
end ;  blv_source_control_repeatMesh


;
;===========================================================================================
;
PRO blv_source_control_event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_source_control_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


Widget_Control, event.top, get_uvalue=info

IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN BEGIN
	blv_source_control_close, info.pInfo
	return
ENDIF

Widget_Control, event.id, Get_UValue=uValue
CASE uValue OF
	'mesh scale': BEGIN
		widget_control, (*info.pInfoSource).wScale, get_value=value
		source=(*info.pInfo).data.system->get_source()
		source->setProperty, dimensionElement_scale=value
		source->trace
		blv_draw_system, info.pInfo
		END
	'axis scale': BEGIN
		widget_control, (*info.pInfoSource).wScaleAxes, get_value=value
		source=(*info.pInfo).data.system->get_source()
		source->setProperty, axis_scale=value
		source->trace
		blv_draw_system, info.pInfo
		END
	'blv_source_control_label_event': BEGIN
		;purpose : to change the label on the axes source X-Y-Z
		widget_control, event.top, get_uvalue=info
		; widget_control, event.id, get_uvalue=button
		widget_control, event.id, get_value=text
		source=(*info.pInfo).data.system->get_source()
		source->getProperty, graphic=model
		axis=model->getbyname('axesX-Y-Z')
		CASE event.id OF
			(*info.pInfoSource).wlabelX: begin
				axisX=axis->getbyname('x')
				axisX->getProperty, title=label
				label->setProperty, strings=text
			end
			(*info.pInfoSource).wlabelY: begin
	 			axisY=axis->getbyname('y')
				axisY->getProperty, title=label
				label->setProperty, strings=text
			end
			(*info.pInfoSource).wlabelZ: begin
	 			axisZ=axis->getbyname('z')
				axisZ->getProperty, title=label
				label->setProperty, strings=text
			end
			else: return
		ENDCASE
		blv_draw_system, info.pInfo
		END
	'blv_source_control_repeatMesh_event': BEGIN
		;purpose : to repeat the mesh to apply as source as specified by widget fields
		widget_control, event.top, get_uvalue=info
		blv_source_control_repeatMesh, info
		END
	'blv_source_control_mesh_event': BEGIN
		;purpose : to change the mesh to apply as source
		widget_control, event.top, get_uvalue=info
		file=dialog_pickfile(title='Open Mesh...', $
			/read,DIALOG_PARENT=event.top, filter='*.wrl')
		if file eq '' then begin
			return
		endif
		widget_control, /HOURGLASS
		modelTest=read_vrml_file(file)
		if obj_isa(modelTest,'idlgrmodel') then begin
			source=(*info.pInfo).data.system->get_source()
			source->setProperty, mesh_file=file, symbol=modelTest
		endif else print, "error while reading file"
source->trace
blv_draw_system, info.pInfo
		END
;srio	'blv_source_control_image_event': BEGIN
;srio		;purpose : to change the image associated with the source
;srio		widget_control, event.top, get_value=info
;srio		END
	'blv_source_control_flipShow_event': BEGIN
		;purpose : to control the binary widget of type Show/Hide
		widget_control, event.top, get_uvalue=info
		; srio widget_control, event.id, get_uvalue=button
		source=(*info.pInfo).data.system->get_source()
		CASE event.id  OF
			(*info.pInfoSource).wFlipAxisX: begin
	 			source->flip, /show_axisX
				end
			(*info.pInfoSource).wFlipAxisY: begin
	 			source->flip, /show_axisY
				end
			(*info.pInfoSource).wFlipAxisZ: begin
	 			source->flip, /show_axisZ
				end
			else: return
		ENDCASE
		source->trace
		blv_draw_system, info.pInfo
		END
	'blv_source_control_trans_event': BEGIN
		;purpose : to control the opacity property of the source
		widget_control, event.top, get_uvalue=info
		source=(*info.pInfo).data.system->get_source()
		source->flip, /transparen
		source->trace
		blv_draw_system, info.pInfo
		END
	'blv_source_control_dismiss_event': BEGIN
		widget_control, event.top, get_uvalue=info
		blv_source_control_close, info.pInfo
		END
	'blv_source_control_showSymbol_event': BEGIN
		;purpose: to control the show property of the source
		widget_control, event.top, get_uvalue=info
		source=(*info.pInfo).data.system->get_source()
		source->flip, /show_symbol
		source->trace
		blv_draw_system, info.pInfo
		END
	else: message,'Option not found: '+uValue
ENDCASE
END


;
;===========================================================================================
;
function blv_Source_control, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_Source_control: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


wBase=widget_base(GROUP_LEADER=(*pInfo).wid.tbl,title='Source Controls',/col, /TLB_KILL_REQUEST_EVENTS, $
				event_pro='blv_source_control_event', /floating)
	source=(*pInfo).data.system->get_source()
	source->getProperty, graphic=model
	axis=model->getbyname('axesX-Y-Z')

	wButton=Widget_Base(wBase,/row)
		wtmp=widget_button(wButton, value='Dismiss',UValue='blv_source_control_dismiss_event')

	; labels group
	wBaseLabels=widget_base(wBase, /frame,/row)
		wLabel=widget_label(wBaseLabels, value='Labels: ')
		wTemp=widget_base(wBaseLabels,/Row)
			wTempX=widget_base(wTemp,/row)
			axisX=axis->getbyname('x')
			axisX->getProperty, title=label
			label->getProperty, strings=text
			xlab=widget_label(wTempX,Value='X:')
			wLabelX=widget_text(wTempX,value=text,/EDITABLE,xsize=10, $
				UValue='blv_source_control_label_event', $
				event_pro='blv_source_control_event')

			axisY=axis->getbyname('y')
			axisY->getProperty, title=label
			label->getProperty, strings=text
			wTempY=widget_base(wTemp,/row)
			ylab=widget_label(wTempY,Value='Y:')
			wLabelY=widget_text(wTempY,value=text,/EDITABLE,xsize=10, $
				UValue='blv_source_control_label_event', $
				event_pro='blv_source_control_event')

			axisZ=axis->getbyname('z')
			axisZ->getProperty, title=label
			label->getProperty, strings=text
			wTempZ=widget_base(wTemp,/row)
			zlab=widget_label(wTempZ,Value='Z:')
			wLabelZ=widget_text(wTempZ,value=text,/EDITABLE,xsize=10, $
				UValue='blv_source_control_label_event', $
				event_pro='blv_source_control_event')

	; Show/Hide axes group
	wBaseAxis=widget_base(wBase,/frame,/row)
		wAxis=widget_label(wBaseAxis, value='Show/Hide axes: ')
		wTemp=widget_base(wBaseAxis,/Row,/NONEXCLUSIVE)

	    wFlipAxisX = WIDGET_BUTTON(wtemp, VALUE='X ', UValue='blv_source_control_flipShow_event')
            source->getProperty, show_axisX=show_axisX
            widget_control, wFlipAxisX, set_button=abs(show_axisX-1)

            wFlipAxisY = WIDGET_BUTTON(wtemp, VALUE='Y ', UValue='blv_source_control_flipShow_event')
            source->getProperty, show_axisY=show_axisY
            widget_control, wFlipAxisY, set_button=abs(show_axisY-1)

            wFlipAxisZ = WIDGET_BUTTON(wtemp, VALUE='Z ', UValue='blv_source_control_flipShow_event')
            source->getProperty, show_axisZ=show_axisZ
            widget_control, wFlipAxisZ, set_button=abs(show_axisZ-1)

	; Axes scale
	source->getProperty, axis_scale=axis_scale
	wScaleAxes=CW_FSlider1(wBase,minimum=0.1,maximum=4.0,/Edit,/Reset, $
		value=axis_scale, uvalue='axis scale', title='Axes scale',/Frame,XSize=375)


    ; VRML model menu 
    wVRML=Widget_Base(wBase,/frame,/Column)
	wtmp=Widget_Label(wVRML, Value='Solid model for representing the source',/Align_Center)
	wMesh=Widget_Button(wVRML, Value='Load a mesh with model (VRML file)...', $
	   UValue='blv_source_control_mesh_event')

    wOptionBase=widget_base(wVRML,/Row,/NONEXCLUSIVE)
    	wTrans=widget_button(wOptionBase,value='Opaque/Frame',UValue='blv_source_control_trans_event')
    		source->getProperty, transparen=trans
    		widget_control, wTrans, set_button=abs(trans-1)
    	wShow=widget_button(wOptionBase,value='Show/Hide source model', $
		UValue='blv_source_control_showSymbol_event')
    		source->getProperty, show_symbol=show
    		widget_control, wShow, set_button=abs(show-1)
	wMeshBase=widget_base(wVRML,/frame,/col)
		source->getProperty,dimensionElement_scale=scale_element
		wScale=CW_FSlider1(wMeshBase,minimum=0.1,maximum=4.0,/Edit,/Reset, $
			value=scale_element, uvalue='mesh scale', title='Mesh scale',XSize=375)

	wbaserepeatMesh=widget_base(wVRML,/frame,/col)
		wButton=widget_button(wbaserepeatmesh, value='Replicate model', $
			uValue='blv_source_control_repeatMesh_event')
		baserepeatMeshX=widget_base(wbaserepeatMesh,/row)
			wXmin=cw_field(baserepeatMeshX, xsize=5, title='X: From ', value=0., /floating)
			wXmax=cw_field(baserepeatMeshX, xsize=5, title='To ', value=0., /floating)
			wXpas=cw_field(baserepeatMeshX, xsize=5, title='Step ', value=0., /floating)
		baserepeatMeshY=widget_base(wbaserepeatMesh,/row)
			wYmin=cw_field(baserepeatMeshY, xsize=5, title='Y: From ',value=0., /floating)
			wYmax=cw_field(baserepeatMeshY, xsize=5, title='To ',value=0., /floating)
			wYpas=cw_field(baserepeatMeshY, xsize=5, title='Step ',value=0., /floating)
		baserepeatMeshZ=widget_base(wbaserepeatMesh,/row)
			wZmin=cw_field(baserepeatMeshZ, xsize=5, title='Z: From ',value=0., /floating)
			wZmax=cw_field(baserepeatMeshZ, xsize=5, title='To ',value=0., /floating)
			wZpas=cw_field(baserepeatMeshZ, xsize=5, title='Step ',value=0., /floating)

	;wImage=widget_button(wBase, Value='Image...',event_pro='blv_source_control_image_event')

pInfoSource=ptr_new(			{wBase:wBase, $
					wScale:wScale, $
					wScaleAxes:wScaleAxes, $
					wXmin:wXmin, $
					wXmax:wXmax, $
					wXpas:wXpas, $
					wYmin:wYmin, $
					wYmax:wYmax, $
					wYpas:wYpas, $
					wZmin:wZmin, $
					wZmax:wZmax, $
					wZpas:wZpas, $
					wLabelX:wLabelX, $
					wLabelY:wLabelY, $
					wLabelZ:wLabelZ, $
					wFlipAxisX:wFlipAxisX, $
					wFlipAxisY:wFlipAxisY, $
					wFlipAxisZ:wFlipAxisZ $
					 })
info={pInfoSource:pInfoSource, pInfo:pInfo}

widget_control, wBase, set_uValue=info
widget_control, wBase, /realize
xmanager, 'blv_source_control', wBase, /no_block

return, wBase
end
