;+
; NAME:
;       blv_CENTER_VIEW.
;
; PURPOSE:
;       This procedure modify the rect_view property of a IdlGrView to 
;		center the view
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;       BLV_CENTER_VIEW, pInfo
;
; INPUTS:
;       pInfo:    A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;		BLV_CENTER_VIEW, pInfo
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-


;*************to center the view**********
pro blv_center_view, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_center_view: error caught: '+!error_state.msg)
   RETURN
ENDIF


get_bounds_bis, (*pInfo).wid.model, xrange, yrange, zrange
(*pInfo).wid.model->getProperty, transform=T
cx=(xrange[0]+xrange[1])/2
cy=(yrange[0]+yrange[1])/2
cz=(zrange[0]+zrange[1])/2
R=transpose(T[0:2,0:2])
c=R#[cx,cy,cz]
lx=-(xrange[0]-xrange[1])
ly=-(yrange[0]-yrange[1])
lz=-(zrange[0]-zrange[1])
lmax=max([lx,ly*4/3])*((*pInfo).data.zoom)
(*pInfo).wid.view->setProperty,VIEWPLAN=[c[0]-Lmax/2,c[1]-Lmax/2,Lmax,Lmax], $
								zclip=[c[2]+Lmax,c[2]-Lmax], $
								eye=c[2]+Lmax*2

end
;***********************************************
