FUNCTION reflection, ray,points,verbose=verbose ; ,flag=flag
;+
; FUNCTION reflection, ray,points ; ,flag=flag
;
;
; Calculates the reflection of a ray (array of all rays in the mirror 
; reference system) with the intersection points (an array of
; structures) 
;
; Inputs: 
;        ray: 7xn array 
;        points: an array of structures of the type: 
;        {xyz:dblarr(3),normal:dblarr(3),flag:-1}
;        (output of intersec_trial)
; Outputs:
;        ray (7xn) with the reflected beam
;
;-


rayref=ray

index1=where(points.flag GT 0)
index2=where(points.flag LE 0)

vref1=dblarr(3,n_elements(ray[0,*]))
vref2=vref1
flag=transpose(points.flag)
IF index1[0] NE -1 THEN BEGIN
  ; computes the normal to the surface at the intercept point
  ;normalized cross product
  ort = points.normal 
  ;vecproduct(points[index1].gradv,points[index1].gradu) 
  ;ort=ort*(-1D)


  ; v.n
  vin = ray[3:5,index1]
  scalar=total(ray[3:5,index1]*ort,1)
  ; replicate it for matrix operations
  scalar=transpose([[scalar],[scalar],[scalar]])

  ; v_ref = v_in - 2 (v_in.n)
  vref1[*,index1] = ray[3:5,index1] - 2*scalar*ort
  vref2[*,index1] = ray[3:5,index1] + 2*scalar*ort

  cos0 = abs(Total(vin*ort,1))
  cos1 = abs(Total(vref1*ort,1))
  cos2 = abs(Total(vref2*ort,1))
  
  IF Keyword_Set(verbose) THEN BEGIN
    FOR i=0L,N_Elements(index1)-1 DO BEGIN
      print,''
      print,'REFLECTION i',index1[i]
      print,'REFLECTION p',points[index1[i]].xyz
      print,'REFLECTION n',ort[*,i]
      print,'REFLECTION cos0',cos0[i]
      print,'REFLECTION cos1',cos1[i]
      print,'REFLECTION cos2',cos2[i]
    ENDFOR
  ENDIF

  vref=vref1
  itmp = where( abs(cos2-cos0) LT 1D-8 ) 
  IF itmp[0] NE -1 THEN BEGIN
    vref[itmp]=vref2[itmp]
    flag[itmp]=2
  ENDIF

  rayref[0:2,index1]=reform(points[index1].xyz)
  rayref[3:5,index1]=vref[*,index1]
  rayref[6,index1]=flag[index1]
ENDIF

IF index2[0] NE -1 THEN rayref[6,index2] = -1

return, rayref

END

