FUNCTION nrbtransform,nrb,tmat
;+
;
; FUNCTION nrbtransform,nrb,tmat
; Translated from MatLab code by D. Bianchi, ESRF, 2006
;
;//
;// Function Name:
;//
;//   nrbtform - Apply transformation matrix to the NURBS.
;//
;// Calling Sequence:
;//
;//   tnurbs = nrbtform(nurbs,tmatrix);
;//
;// Parameters:
;//
;//   nurbs : NURBS data structure (see nrbmak for details).
;//
;//   tmatrix     : Transformation matrix, a matrix of size (4,4) defining
;//                 a single or multiple transformations.
;//
;//   tnurbs    : The return transformed NURBS data structure.
;//
;// Description:
;//
;//   The NURBS is transform as defined a transformation matrix of size (4,4),
;//   such as a rotation, translation or change in scale. The transformation
;//   matrix can define a single transformation or multiple series of
;//   transformations. The matrix can be simple constructed by the functions
;//   vecscale, vectrans, vecrotx, vecroty, and vecrotz.
; 
;    ALL TRANSFORMATIONS ARE DONE WITH RESPECT TO THE ORIGIN
;
;    Example: 
;    mirr = nrbmakecylinder(100,ll=100,ww=10)
;    nrbplot,mirr,100,100
;    ; rotation 45 deg with respect to z 
;    z = vecrotz(!dpi/4)
;    m2=nrbtransform(mirr,z)
;
;    ; rotation 45 deg with respect to z plus a 
;    ; rotation 45 deg with respect to y
;    y = vecroty(!dpi/4)
;    m2=nrbtransform(mirr,y##z)
;    nrbplot,m2,100,100;-
; 
;-


IF n_elements(nrb.dim) EQ 2 THEN BEGIN

dim = size(nrb.coefs,/dimensions)

cof = transpose(reform(transpose(nrb.coefs,[1,0,2]),dim[1],dim[0]*dim[2]))
cof = tmat##cof

cof = transpose(reform(transpose(cof),dim[1],dim[0],dim[2]),[1,0,2])

temp=nrbstruct(cof,nrb.uknots,nrb.vknots)

ENDIF ELSE BEGIN

cof = tmat##nrb.coefs

temp=nrbstruct(cof,nrb.uknots)
ENDELSE

return, temp


END
