FUNCTION nrbderstruct, nrb
;//
;// Function Name:
;//
;//   nrbderiv - Construct the first derivative representation of a
;//              NURBS curve or surface.
;//
;// Calling Sequence:
;//
;//   ders = nrbderiv(nrb);
;//
;// Parameters:
;//
;//   nrb     : NURBS data structure, see nrbmak.
;//
;//   ders    : A data structure that represents the first
;//      derivatives of a NURBS curve or surface.
;//
;// Description:
;//
;//   The derivatives of a B-Spline are themselves a B-Spline of lower degree,
;//   giving an efficient means of evaluating multiple derivatives. However,
;//   although the same approach can be applied to NURBS, the situation for
;//   NURBS is a more complex. I have at present restricted the derivatives
;//   to just the first. I don't claim that this implentation is
;//   the best approach, but it will have to do for now. The function returns
;//   a data struture that for a NURBS curve contains the first derivatives of
;//   the B-Spline representation. Remember that a NURBS curve is represent by
;//   a univariate B-Spline using the homogeneous coordinates.
;//   The derivative data structure can be evaluated later with the function
;//   nrbdeval.



  ;// taking derivatives along the u direction

IF n_elements(nrb.dim) EQ 2 THEN BEGIN
  dknots = nrb.uknots;
  dcoefs = reform(nrb.coefs,nrb.dim[0],4*nrb.dim[1]);
  dcoefs = bspderiv(nrb.p,dcoefs,dknots,dk=dk);
  dcoefs = reform(dcoefs,[nrb.dim[0]-1,4,nrb.dim[1]])

  deru = nrbstruct(dcoefs,dk,nrb.vknots)

  ;// taking derivatives along the v direction
  dknots = nrb.vknots;
  dcoefs = transpose(nrb.coefs,[1,0,2])
  dcoefs = transpose(reform(dcoefs, 4*nrb.dim[0],nrb.dim[1]))
  dcoefs = bspderiv(nrb.q,dcoefs,dknots,dk=dk)

  dcoefs = reform(transpose(dcoefs),[4,nrb.dim[0], nrb.dim[1]-1])
  dcoefs= transpose(dcoefs,[1,0,2])

  derv = nrbstruct(dcoefs,nrb.uknots,dk)


;else
;  ;// NURBS structure represents a curve
;
;  [dcoefs,dknots] = bspderiv(degree,nurbs.coefs,nurbs.knots);
;  dnurbs = nrbmak(dcoefs, dknots);

dnrb={deru:deru,derv:derv}

ENDIF ELSE BEGIN

  dknots = nrb.uknots
  dcoefs = bspderiv(nrb.p,nrb.coefs,dknots,dk=dk);
  deru = nrbstruct(dcoefs, dk);
  dnrb = {deru:deru}

ENDELSE

return,dnrb

end