FUNCTION int_guess,patch,ray,nu=nu,nv=nv,verbose=verbose, $
  returnPoint=returnPoint,plot=fplot

;+
;
;
; ************  IT DOES NOT WORK ***********************
;
;
; FUNCTION int_guess,patch,ray,nu=nu,nv=nv,verbose=verbose, $
;  returnPoint=returnPoint
;
; computes a guess for the intersection by making 
; intersections with planes in a nu x nv grid
;
; Inputs:
;      patch: the nurbs surface
;      ray: an array 7 x n (x,v and flag)
; Outputs: 
;      It returns a structure (or an array of structures) with guess 
;         intervals {u:[min,max],v:[min,max]}
;         Alternatively (if the kw returnPoint is used) returns the 
;         x,y,z coordinates of the intersection point. 
;
; Keywords: 
;      nu: the number of points in the u grid
;      nv: the number of points in the v grid
;      returnPoint: if set, returns the intersect point, instead of u,v
;      plot: set this flag to create a plot of the results
;
;
;-

IF N_Elements(nu) EQ 0 THEN nu=9
IF N_Elements(nv) EQ 0 THEN nv=10

;u=nrblinear(0D,1D,nu)
;v=nrblinear(0D,1D,nv)


u=nrblinear(min(patch.uknots),max(patch.uknots),nu)
v=nrblinear(min(patch.vknots),max(patch.vknots),nv)

uDelta = abs(u[1]-u[0])
vDelta = abs(v[1]-v[0])

;print,u,v
z=nrbeval(patch,u,v)

;ixx = uniq(z[*,0,*])
;xx = Reform(z[ixx])
;xx = xx[Sort(xx)]
;iyy = uniq(z[*,1,*])
;yy = Reform(z[iyy])
;yy = yy[Sort(yy)]

;v1 = DblArr(nu-1,3,nv-1)
;v2 = DblArr(nu-1,3,nv-1)
v00 = DblArr(3,(nu-1)*(nv-1))
;v00_deltau = DblArr(3,(nu-1)*(nv-1))
;v00_deltav = DblArr(3,(nu-1)*(nv-1))
v11 = DblArr(3,(nu-1)*(nv-1))
v22 = DblArr(3,(nu-1)*(nv-1))
uv = DblArr(4,(nu-1)*(nv-1))

k=0L
FOR i=0L,nu-2 DO BEGIN
  FOR j=0L,nv-2 DO BEGIN
   ;v1[i,*,j] = - z[i,*,j] + z[i+1,*,j]
   ;v2[i,*,j] = - z[i,*,j] + z[i,*,j+1]
   v00[*,k]=z[i,*,j]
   ;v00_deltau[*,k]=z[i+1,*,j]
   ;v00_deltav[*,k]=z[i,*,j+1]
   ;v11[*,k]=v1[i,*,j]
   ;v22[*,k]=v2[i,*,j]
   v11[*,k]= - z[i,*,j] + z[i+1,*,j]
   v22[*,k]= - z[i,*,j] + z[i,*,j+1]
   uv[0,k]=u[i]
   uv[1,k]=u[i+1]
   uv[2,k]=v[j]
   uv[3,k]=v[j+1]
   ;print,i,j,v00[*,k]
   k=k+1
  ENDFOR
ENDFOR

;xx = v00[0,*]
;xx = xx[Uniq(xx,Sort(xx))]
;yy = v00[1,*]
;yy = yy[Uniq(yy,Sort(yy))]


;
; now, the planes are defined by a point v00 and the normal v33
;
v33 = vecproduct(v11,v22)
v33 = vecnorm(v33,/returnNormalized)


;
; ray
; 
x0 = ray[0:2,*]
v0 = ray[3:5,*]
f0 = ray[6,*]


;
; loop over the rays to perform intersection
;
pInter=Replicate({xyz:dblarr(3),normal:dblarr(3), flag:-1},N_Elements(f0))
strout = Replicate({u:[0D,0], v:[0D,0]}, N_Elements(f0))

FOR i=0L,N_Elements(f0)-1 DO BEGIN
  flg = 1
  v0i = Reform(v0[*,i])#Replicate(1,(nu-1)*(nv-1))
  x0i = Reform(x0[*,i])#Replicate(1,(nu-1)*(nv-1))

  den = vecdot(v33,v0i)
  ibad = where(abs(den) LE 1D-9) 
  IF ibad[0] NE -1 THEN f0[ibad]=-1
  num = vecdot(v33,v00-x0i)
  t = num/den
  ; this are the intersection points onto all cells
  pp = x0i+v0i*([1D,1,1]#t)

  ; 
  ; now we have to select the good cell that really intersects with the ray 
  ; 

  ;
  ; method 1: the closest interaction
  ;
  ; computes distances and select the right origin
  ; problem: if the surface is not very flat, it fails. 
  tmin = min(t,iit)

  ;
  ; method 2: the cell whose interaction lyes in the positive part 
  ;           of the cell, and is closer to the cell's origin
  ;
  ; 
  ; computes the projection of  pp-v00 onto the basis vectors v11 and v22
  ; 
  proju = vecdot(pp-v00,vecnorm(v11,/returnNormalize))
  proju = proju/vecnorm(v11)
  projv = vecdot(pp-v00,vecnorm(v22,/returnNormalize))
  projv = projv/vecnorm(v22)

  ; remove negative points (mark as +infinity) 
  ibad = where(proju LT 0 OR projv LT 0)
  ;FOR jj=0,N_Elements(projv)-1 DO print,jj,proju[jj],projv[jj]
  IF ibad[0] NE -1 THEN BEGIN
    projv[ibad]=1D6
    proju[ibad]=1D6
  ENDIF
  ; calculate the one that is closer to its origin
  uvmin = min(proju^2+projv^2,iiuv)

  ; another way (wrong!)
  ;igood = where( (proju GE 0 AND proju LE 1) AND (projv GT 0 AND projv LT 1))
  ;if igood[0] EQ -1 THEN flg=-1
  ;iiuv = igood[0]>0

  ; 
  ; method 3: get the indice of the cell where the ray hits
  ;
  ;ppp = pp-v00
  ;itmp = where(ppp[0,*] GE 0)
  ;tmp = min(itmp,ix)
  ;itmp = where(ppp[1,*] GE 0)
  ;tmp = min(itmp,iy)
  


  ; 
  ; intersection with basal plane
  ;

  isel = iit
  tbasal = -x0[2,i]/v0[2,i]

  IF Keyword_Set(verbose) THEN BEGIN
    print,' '
    print,'INT_GUESS ray index: ',i
    print,'INT_GUESS tmin, iit: ',tmin,iit
    print,'INT_GUESS iiuv,proju,projv: ',iiuv,proju[iiuv],projv[iiuv]
    ;print,'INT_GUESS ix iy: ',ix,iy
    print,'INT_GUESS t-basal plane: ',tbasal
    print,'INT_GUESS intersection with basal plane: ',$
       x0[*,i]+tbasal*v0[*,i]
    ;IF iit NE iiuv THEN print,'**iit NE iiuv**'
    print,'INT_GUESS t-intersec: ',t[isel]
  ENDIF

  
  ;IF it[0] EQ -1 THEN Message,'Intersection not found'
  

  ;pInter[*,i] = x0[*,i]+t[isel]*v0[*,i]
  pInter[i].xyz = x0[*,i]+t[isel]*v0[*,i]
  pInter[i].normal = v33[*,isel]
  pInter[i].flag = 1 ; flg

  ;uint = interpol(u,uuu,pInter[0,i])
  ;vint = interpol(v,vvv,pInter[1,i])
  
  ; full interval 
  ;strout[i].u = [u[0],u[nu-1]]
  ;strout[i].v = [v[0],v[nv-1]]

  ; closer distance
  strout[i].u = uv[0:1,isel]
  strout[i].v = uv[2:3,isel]

  ;strout[i].u = [(uv[0,isel]-udelta*1)>u[0]<u[nu-1],(uv[0,isel]+udelta*1)>u[0]<u[nu-1]]
  ;strout[i].v = [(uv[1,isel]-vdelta*1)>v[0]<v[nv-1],(uv[1,isel]+vdelta*1)>v[0]<v[nv-1]]


  IF Keyword_set(verbose) THEN BEGIN
    print,'INT_GUESS intersection at xyz: ',pInter[i].xyz
    print,'INT_GUESS intersection at approx u: ',strout[i].u
    print,'INT_GUESS intersection at approx v: ',strout[i].v
  ENDIF
ENDFOR

IF Keyword_Set(fplot) THEN BEGIN
  nrbplot,z
  iplot,pInter.xyz,/over,psym=3
ENDIF


IF Keyword_Set(returnPoint) THEN RETURN,pInter ELSE RETURN,strout
END

