; AIM
;   convert a standard surface shadow file in a grid matrix 4-by-nx-by-ny
;
;the SHADOW's file is defined in the first row by 2 numbers nx and ny
;the 2nd row defines the ny values
;from the 3rd row till the end are defined:
;in the first coloumn the nx values and all the other columns defines the z
;grid values z is defined by a grid of nx*ny values

;ARGUMENTS
;       FILE = string with location of the file '*.*' (insert all folder path if is not in the current directory)
;OUTPUT
;       GRID = grid of coefs readable by the function nrbmak(coefs,knots)

; Developed by
; Davide Bianchi 06/16/2006
; ESRF CopyRight(C)
;
;

function fconvgrid, coefs,weights=weights,xx=xx,yy=yy,zz=zz




IF keyword_set(coefs) THEN BEGIN
IF n_elements(coefs) EQ 0 THEN file='E:\Golan\ESRF\Raytracing\idld\da sistemare\NURBS\surface.dat'
IF size(coefs,/type) NE 7 THEN BEGIN
message,'file must be a string'
ENDIF

readgridfile, coefs, xx=xx, yy=yy, zz=zz, nx=nx, ny=ny
ENDIF

IF keyword_set(xx)THEN nx=n_elements(xx)
IF keyword_set(yy)THEN ny=n_elements(yy)

grid=dindgen(nx,4,ny)

FOR ii=0,ny-1 DO BEGIN
grid(*,0,ii) = xx
grid(*,1,ii) = yy(ii)
grid(*,2,ii) = zz(ii,*)
ENDFOR

;== read the weights file==;
IF keyword_set(weights) THEN BEGIN
readgridfile, weights, zz=zz
    FOR jj=0,ny-1 DO BEGIN

    grid(*,3,ii) = zz(ii,*)

    ENDFOR
ENDIF ELSE BEGIN
grid(*,3,*)=1
ENDELSE
return,grid
END