FUNCTION decasteljauS, bzr, u, v

S=dblarr(3)

IF type(bzr) EQ 8 THEN BEGIN
nx=bzr.dim[0]
ny=bzr.dim[1]
xgrid=bzr.xgrid
ygrid=bzr.ygrid
zgrid=bzr.zgrid
ENDIF ELSE BEGIN
dim=size(bzr,/dimensions)
nx=dim[0]
ny=dim[2]
xgrid=grid2mat(bzr,v=0)
ygrid=grid2mat(bzr,v=1)
zgrid=grid2mat(bzr,v=2)
ENDELSE


IF nx LE ny THEN BEGIN
Q=dblarr(ny,3)
    FOR jj=0,ny-1 DO BEGIN
    Q[jj,0]=decasteljauC(xgrid[jj,*],nx-1,u)
    Q[jj,1]=decasteljauC(ygrid[jj,*],nx-1,u)
    Q[jj,2]=decasteljauC(zgrid[jj,*],nx-1,u)
    ENDFOR

    S[0]=decasteljauC(Q[*,0],ny-1,v)
    S[1]=decasteljauC(Q[*,1],ny-1,v)
    S[2]=decasteljauC(Q[*,2],ny-1,v)

ENDIF ELSE BEGIN

Q=dblarr(nx,3)

    FOR jj=0,ny-1 DO BEGIN

    Q[jj,0]=decasteljauC(xgrid[*,jj],ny-1,v)
    Q[jj,1]=decasteljauC(ygrid[*,jj],ny-1,v)
    Q[jj,2]=decasteljauC(zgrid[*,jj],ny-1,v)

    ENDFOR

    S[0]=decasteljauC(Q[*,0],nx-1,u)
    S[1]=decasteljauC(Q[*,1],nx-1,u)
    S[2]=decasteljauC(Q[*,2],nx-1,u)

    ENDELSE

Return, S

END