;// Compute the control points and knot sequence a univariate B-Spline
;// derivative.
;//
;// MATLAB SYNTAX:
;//
;//        [dc,dk] = bspderiv(d,c,k)
;//
;// INPUT:
;//
;//   d - degree of the B-Spline
;//   c - control points          double  matrix(mc,nc)
;//   k - knot sequence           double  vector(nk)
;//
;// OUTPUT:
;//
;//   dc - control points of the derivative     double  matrix(mc,nc)
;//
;// KEYWORDS
;//
;//   dk - knot sequence of the derivative      double  vector(nk)
;//
;//


;;// Modified version of Algorithm A3.3 from 'The NURBS BOOK' pg98.
FUNCTION bspderiv, d,c,knots,dk=dk

dim=size(c,/dimensions)

nk=n_elements(knots)
dk=dblarr(nk-2)

  ;// control points of the derivative
  dctrl = dblarr(dim[0]-1,dim[1])

  FOR ii=0,dim[0]-2 DO BEGIN
    tmp = d / (knots[ii+d+1] - knots[ii+1])
    FOR jj = 0,dim[1] - 1 DO BEGIN
      dctrl[ii,jj] = tmp * (c[ii+1,jj] - c[ii,jj])
    ENDFOR
  ENDFOR

  jj = 0;

  FOR ii = 1L,nk-2 DO dk[jj++] = knots[ii]

return, dctrl

END