;
;write  SHADOW'S formated surface
;

PRO __nrbwriteshadowsurf, grid, coefs=coefs, weights=weights

X_arr = reform(grid(*,0,0))
Y_arr = reform(grid(0,1,*))

Z_grid = transpose(reform(grid(*,2,*)))
W_grid = transpose(reform(grid(*,3,*)))

XZ_grid = [transpose(x_arr),Z_grid]
XW_grid = [transpose(x_arr),W_grid]

nx=n_elements(X_arr)
ny=n_elements(Y_arr)

h=string(ny+1)

format1='((2I5,:,1x))'

format2='('+h+'(E,1x))'

IF keyword_set(coefs) EQ 0 THEN coefs = 'coefs.dat'
IF keyword_set(weights) EQ 0 THEN weights = 'weights.dat'

openw, lun1,coefs, /get_lun
openw, lun2,weights, /get_lun

printf, lun1, nx,ny,fo=format1
printf, lun2, nx,ny,fo=format1

printf, lun1,y_arr,fo=format2
printf, lun2,y_arr,fo=format2

FOR j=0,nx - 1 DO BEGIN
  printf, lun1, XZ_grid(*,j), fo=format2
  printf, lun2, XW_grid(*,j), fo=format2
ENDFOR

free_lun, lun1,lun2

print,'File '+coefs+' written to disk.'
print,'File '+weights+' written to disk.'

END
