FUNCTION __nrbcirc,rr,oo=oo,sang=sang,eang=eang
;+
; FUNCTION __nrbcirc,rr,oo=oo,sang=sang,eang=eang
; Translated from MatLab code by D. Bianchi, ESRF, 2006
;
;//
;// Function Name:
;//
;//   __nrbcirc - Construct a circular arc.
;//
;// Calling Sequence:
;//
;//   crv = nrbarc()
;//   crv = nrbarc(rr)
;//   crv = nrbarc(rr,oo)
;//   crv = nrbarc(rr,oo,sang,eang)
;//
;// Parameters:
;//
;//   rr    : rr of the circle, default 1.0
;//
;//   oo    : oo of the circle, default (0,0,rr)
;//
;//   sang  : Start angle, default 0 degrees
;//
;//   eang  : End angle 360 degrees
;//
;//   crv     : NURBS curve for a circular arc.
;//
;// Description:
;//
;//   Constructs NURBS d,ata structure for a circular arc in the x-y plane. If
;//   no rhs arguments are supplied, a unit circle with oo (0.0d,0.0) is
;//   constructed.
;//
;//   Angles are defined as positive in the anti-clockwise direction.
;//  D.M. Spink
;//  Copyright (c) 2000.
;-

IF n_elements(rr) EQ 0 THEN rr = 1d
IF NOT keyword_set(oo) THEN oo = [0d,0d,0d]
IF NOT keyword_set(sang) THEN sang = 0
IF NOT keyword_set(eang) THEN eang = 2*!dpi


sweep = eang - sang;       ;// sweep angle of arc

IF sweep LT 0 THEN sweep = 2*!dpi + sweep
temp=nrblinear(0,2*!dpi,5)
e=where(abs(sweep) LE temp)
CASE e[0] OF
 1: BEGIN
                narcs = 1;                ;// number of arc segments
                knots = [0d,0d,0d,1d,1d,1d];
             END
 2: BEGIN

  narcs = 2;
  knots = [0d, 0d, 0d, 0.5d, 0.5d, 1d, 1d, 1d];
  END

3: BEGIN
  narcs = 3;
  knots = [0d, 0d, 0d, 1d/3d, 1/3d, 2d/3d, 2d/3d, 1d, 1d, 1d];
  END
ELSE: BEGIN
  narcs = 4;
  knots = [0d, 0d, 0d, 0.25d, 0.25d, 0.5d, 0.5d, 0.75d, 0.75d, 1d, 1d, 1d];
  END
ENDCASE

dsweep = sweep/(2*narcs);     ;// arc segment sweep angle/2

;// d,etermine mid,d,le control point and, weight
wm = cos(dsweep);
x  = rr*wm;
y  = rr*sin(dsweep);
xm = x+y*tan(dsweep);

;// arc segment control points
ctrlpt = [[x, wm*xm, x],$    ;// w*x - coord,inate
          [-y, 0d,   y],$;   ;// w*y - coord,inate
          [0d, 0d,  0d],$;   ;// w*z - coord,inate
          [1d, wm,  1d]];    ;// w   - coord,inate

;// build, up complete arc from rotated, segments
coefs = dblarr(2*narcs+1,4);   ;// nurbs control points of arc
xx = vecrotz(sang + dsweep);
coefs[0:2,*] = xx##ctrlpt;     ;// rotate to start angle
xx = vecrotz(2*dsweep);

FOR n = 1,narcs-1 DO BEGIN
   m = 2*n+[1, 2];
   coefs[m,*] = xx##coefs[m-2,*];

ENDFOR

index=where(abs(coefs) LT 1e-13)
IF index[0] NE -1 THEN coefs(index)=0d

;// vectrans arc if necessary

  xx = vectrans(oo);
  coefs = xx##coefs;

curve = nrbstruct(coefs,knots);
return, curve
END
