
;+
; 
; NAME: 
;	SOURCE__DEFINE
;
; PURPOSE:
;	Object class and methods to handle SHADOW source input variables.
;	Used with ShadowVUI application. 
;
; CATEGORY:
;	Object tools
;
; CALLING SEQUENCE:
;	src1 = Obj_New('source',input)
;	src1-><method>
;
; F=Function, P=Procedure
;
; METHODS:
;	INIT(F)	called when the object is created with o1=Obj_New('source',input)
;		INPUTS:
;			input: a SHADOW file 'start.00'
;
;	CLEANUP(P)	called when the object is destroyed with Obj_destroy,o1
;
;	INFO(P)	just prints a help
;
;	GETVALUE(F)   used to return the value of a variable
;		INPUTS:
;                     input: a string with the variable name
;	SETVALUE(P)   used to set the value of a variable
;		INPUTS:
;                     input: either a structure with all variables or a
;                            scalar variable with the value for the 
;                            tag set in NAME
;                     name: (optional) the tag name
;
; EXAMPLE:
;
;	src=obj_new('source')
;       src->load,'start.00'
;       print,src->getValue('NPOINT')
;	src->setValue,6666,'NPOINT'
;       print,src->getValue('NPOINT')
;       src->write,'tmp.00'
;       obj_destroy,src
;
;
; MODIFICATION HISTORY:
;	Initial version  by M. Sanchez del Rio, September 2011,
;
;-

;
;===============================================================================
;
PRO source::load,file
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'source::load: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

tmp = read_gfile(file)

copy_structure,tmp,*(self.str)

END

;
;===============================================================================
;
PRO source::write,file
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'source::write: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

write_gfile,*(self.str),file

END
;
;===============================================================================
;
FUNCTION source::getvalue,input

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'SOURCE::VALUE: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN,0
ENDIF

str =  *(self.str)
case type(input) of
 0: return,str  ; none
 7: BEGIN ; string
    itmp = tag_exist(str,input,index=index)
    IF index LT 0 THEN BEGIN
      print,'source::getvalue: Error in keyword name: '+input
      RETURN,0
    ENDIF
    RETURN,str.(index)
    END
 2: BEGIN ; integer
    return,str.(input)
    END
 3: BEGIN ; long
    return,str.(input)
    END
    else:
endcase
 

END


;
;===============================================================================
;
PRO source::setvalue,value,input

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'source::value: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

IF N_Elements(input) GT 0 THEN BEGIN 
    str =  *(self.str)
    itmp = tag_exist(str,input,index=index)
    IF index LT 0 THEN BEGIN
      print,'source::setvalue: Error in keyword name: '+input
      RETURN
    ENDIF
    str.(index)=value
    *(self.str) = str
    RETURN
ENDIF
copy_structure, value,*(self.str)

END

;
;===============================================================================
;
PRO source::info

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'source::info: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
help,/str,*self.str
help,/obj,self

END


;
;===============================================================================
;
PRO source::cleanup

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'source::cleanup: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

IF Ptr_Valid(self.str) THEN Ptr_Free,self.str
END

;
;===============================================================================
;
FUNCTION source::init, input 



Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
    'SOURCE::INIT: error caught: '+!err_string)
  Catch, /Cancel
  On_Error,2
  RETURN,0
ENDIF

IF ptr_valid( self.str ) EQ 0 THEN BEGIN
  ds=sdep(/ds)
  file = getenv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'data'+$
       ds+'/start_geom.00'
;
  IF checkFile(file) NE 1 THEN BEGIN
    errMessage = 'source_define: Error accessing file: '+file
    print,errMessage
    RETURN,0
  ENDIF

  tmp1 = read_gfile(file)
  self.str=ptr_new(tmp1)
ENDIF
CASE Type(input) OF 
 0: BEGIN       ; no input
    END
 7: BEGIN       ; string
  tmp=read_gfile(input)
  tmp1=*(self.str)
  copy_structure,tmp,tmp1
  *(self.str)=tmp1
  END
 8: BEGIN       ; structure
  tmp1=*(self.str)
  copy_structure,input,tmp1
  *(self.str)=tmp1
  END
 11: BEGIN       ; object (copy it)
  tmp=read_gfile(input)
  tmp1=*(self.str)
  copy_structure,tmp,tmp1
  *(self.str)=tmp1
  END
 else: 
ENDCASE

RETURN,1
END

;
;===============================================================================
;
PRO source__define
  tmp = {source, str:Ptr_New() }
END

