Pro seed,inp,seeds
;+
; NAME:
;	SEED
;
; PURPOSE:
;	This procedure changes the seed in a source gfile (or its
;	associated IDL structure).
;
; CATEGORY:
;	SHADOW
;
; CALLING SEQUENCE:
; 
;	seed,input [,seeds]
;
; OPTIONAL INPUTS:
;	input:	either the file name or the IDL structure to be loaded. 
;
; OPTIONAL OUTPUTS:
;	seeds:	a 2-dim array containing the old and the new seeds
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	None. It changes the file or the structure.
;
; PROCEDURE:
;	extracts the original seed from istar1, and updates it using
;	tmp = randomu(istar1)
;	istar1=2*istar1+1
; EXAMPLE:
;
;		seed,'start.00'
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio, srio@esrf.fr, 97/11/05
;	10/02/2000 changed random generator to randomu1.pro
;	19/10/2000 added seeds. Fix a bug: new start seed is not longer
;		2*newseed+1 just newseed.
;-
on_error,2

if n_params() EQ 0 then inp='start.00'
case type(inp) of
  7: begin
     err=0
     str=read_gfile(inp)
     if not(keyword_set(str)) then begin
	message,/info,'Error getting input file: '+inp
 	return
     endif
     seed_old = str.istar1
     seed_new = seed_old
     tmp = randomu1(seed_new)
     if seed_old EQ seed_new then begin
       message,/info,'Error updating seed: '+strcompress(seed_old,/rem)+$
	' -> '+strcompress(seed_new,/rem)
     endif
     ;str.istar1=2L*seed_new+1
     str.istar1=seed_new
     write_gfile,str,inp
     message,/info,'Seed updated: '+strcompress(seed_old,/rem)+$
	' -> '+strcompress(str.istar1,/rem)
     seeds = [seed_old,str.istar1]
     end
  8: begin
     str = inp
     seed_old = str.istar1
     seed_new = seed_old
     tmp = randomu(seed_new)
     if seed_old EQ seed_new then begin
       message,/info,'Error updating seed: '+strcompress(seed_old,/rem)+$
	' -> '+strcompress(seed_new,/rem)
     endif
     ;str.istar1=2*seed_new+1
     str.istar1=seed_new
     inp = str
     message,/info,'Seed updated: '+strcompress(seed_old,/rem)+$
	' -> '+strcompress(inp.istar1,/rem)
     seeds = [seed_old,inp.istar1]
     end
  else: begin
     message,/info,'Error: invalid input.'
     return
     end
endcase
end
