FUNCTION vecrotz,angle, deg=deg
;//
;+
;
; FUNCTION vecrotz,angle, deg=deg
;
; Written by D. Bianchi, ESRF, 2006
;
;// Function Name:
;//
;//   vecrotz - Transformation matrix for a rotation around the z axis.
;//
;// Calling Sequence:
;//
;//   rz = vecrotz(angle);
;//
;// Parameters:
;//
;//   angle : rotation angle defined in radians
;//
;//   rz       : (4x4) Transformation matrix.
;//
;//
;// Description:
;//
;//   Return the (4x4) Transformation matrix for a rotation about the z axis
;//   by the defined angle.
;//
;//   The matrix is:
;//
;//         [  cos(angle)  -sin(angle)       0          0]
;//         [ -sin(angle)   cos(angle)       0          0]
;//         [      0            0            1          0]
;//         [      0            0            0          1]
;//
;// Examples:
;//
;//  Rotate the NURBS line (0.0 0.0 0.0) - (3.0 3.0 3.0) by 45 degrees
;//  around the z-axis
;//
;//    line = nrbline([0.0 0.0 0.0],[3.0 3.0 3.0]);
;//    trans = vecrotz(;//pi/4);
;//    rline = nrbtform(line, trans);
;-

IF keyword_set(deg) THEN angle=angle*!dpi/180D

sn = sin(angle);
cn = cos(angle);

rz = [[cn, -sn, 0, 0], [sn, cn, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]]

ind=where(abs(rz) LT 1e-6)
rz[ind]=0

return, rz

END
