
;+
;
; FUNCTION vecnorm,vec,returnNormalized=returnNormalized
;
; Returns the normalised vector in 2D
;
;    Input:
;          vec: a vector or array of vectors
;
;    Output: 
;         the norm or normalized vector
;
;    Keywords: 
;         returnNormalized: if set, the function returns the normalized 
;         vector, otherwose it returns the norm
;
;
;
; Written by D. Bianchi, ESRF, 2006
;
; Modified: 
;    2006/12/13 srio@esrf.fr accepts an array of vectors, (3xn) or (mxn),
;               and the possibility to return the norm or normalized
;               vector
;-
FUNCTION vecnorm,vec,returnNormalized=returnNormalized



temp=Sqrt(Total(vec^2,1))
IF Keyword_Set(returnNormalized) THEN BEGIN
  sz = size(vec,/Dimensions)
  RETURN,vec/(temp##Replicate(1,sz[0]))
ENDIF ELSE BEGIN
  RETURN,temp
ENDELSE
END
