FUNCTION shray2plane, origin,direction

;+
; FUNCTION shray2plane, origin,direction
; input: two arrays (3,npoints) containing the starting positions and
;        directions of the rays. 
; output: a structure (or array of structures) with two planes per ray, 
;         the intersection of them is the ray.
;** Structure <81c82b4>, 4 tags, length=56, data length=56, refs=1:
;   NX  DOUBLE    Array[3]   ; A,B,C of plane 1 (normal to it)
;   DX  FLOAT        -0.0286650  ; D (Ax+By+Cx+D=0)
;   NY  DOUBLE    Array[3]   ; same for plane 2 
;   DY  FLOAT          -18.4130
; example: 
; plane=shray2plane(ray[0:2,*],ray[3:5,*]) ;struct array, all rays by 2 plane
;
; 
;
;- 



test = where( direction[0,*] EQ 0 AND direction[1,*] EQ 0)
IF test[0] NE -1 THEN message,/continue,'Failed to find perpendicular plane'


nray=n_elements(origin[0,*])
plane = {nx:dblarr(3), dx:0., ny:dblarr(3), dy:0.}
plane = replicate(plane, nray)

zero = dblarr(nray)

vx = reform(direction[0,*])
vy = reform(direction[1,*])
vz = reform(direction[2,*])
;plane 1



;plane 1 coefficients
a1 = -vy
b1 = vx
c1 = zero

det=1d   ;sqrt(a1^2+b1^2+c1^2)

; this is the vector normal to plane 1 (A,B,C coeffs)
plane.nx = transpose([ [a1/det],[b1/det],[c1/det] ])
; this is D, calculated as: x.n = o.n  (o-origin)
plane.dx = -(total(origin*plane.nx,1))

;plane 2

;plane 2 coefficients
;a2=vx
;b2=vy
;c2=-(vx^2+vy^2)/vz
; this is [v] cross [plane.nx]
a2=vx*vz
b2=vy*vz
c2=-(vx^2+vy^2)

det=1;  sqrt(a2^2+b2^2+c2^2)

plane.ny = transpose([[a2/det],[b2/det],[c2/det]])
plane.dy = -(total(origin*plane.ny,1))


return, plane

END
