;AIM calculus of the knots vector for interpolation of the coefs
;ARGUMENTS
;   GRID = grid of coefficients in the form (n-by-m-by-#number of grid line)
;INPUT KEYWORD
;   M = NURBS degree along u parametric variable (3 as default)
;   N = NURBS degree along v parametric variable (3 as default)
;OUTPUT KEYWORD
;   UU= parametric points by centripetal method along the U direction
;   VV= parametric points by centripetal method along the V direction

FUNCTION nrbinterpknots, grid, p=p, q=q
;--------------------------------------------------;
IF keyword_set(p) EQ 0 THEN p=3
IF keyword_set(q) EQ 0 THEN q=3

p=double(p)
q=double(q)

nu=n_elements(reform(grid(*,1,0)))
n=nu-1
nv=n_elements(reform(grid(0,1,*)))
m=nv-1



;/*==========paramentric U array by centripetal method (miss ref)========*/;
uumat=dblarr(nv,nu);

FOR ss=0,m DO BEGIN
    uumat(ss,n)=1.0
    chl=0.0;
    FOR tt=1,n DO chl += sqrt(norm((grid(tt,0:2,ss) - grid(tt-1,0:2,ss)),/double))

    FOR rr=1,nu-2 DO BEGIN
        uumat(ss,rr)=uumat(ss,rr-1) + sqrt(norm((grid(rr,0:2,ss) - grid(rr-1,0:2,ss)),/double))/chl;
    ENDFOR
ENDFOR

upar = dblarr(nu)
upar(n) = 1.0

FOR rr=1,n-1 DO BEGIN
    sum=0.0
    FOR ss=0,nv-1 DO sum += uumat(ss,rr)
    upar(rr)=sum/(nv);
ENDFOR


;====NON PERIODIC KNOTS ARRAY along U====;
 knots1=dblarr(n-p)

 FOR kk=0,n-p-1 DO BEGIN
     sum=0.0
     FOR hh=kk+1,kk+p DO sum += upar(hh)
     knots1(kk)=1/p*sum
 ENDFOR

au=dblarr(p+1)
bu=dblarr(p+1)
bu(*)=1D
u_knots=[au, knots1, bu]

;/*==========paramentric V array by centripetal method (miss ref)========*/;
vpar = dblarr(nv)
vpar(m) = 1.0
vvmat=dblarr(nu,nv)

FOR ss=0,n DO BEGIN
    vvmat(ss,m)=1.0
    chl=0.0
    FOR tt=1,m DO chl += sqrt(norm((grid(ss,0:2,tt) - grid(ss,0:2,tt-1)),lnorm=2,/double))
    FOR rr=1,m-1 DO BEGIN
        vvmat(ss,rr)=vvmat(ss,rr-1) + sqrt(norm((grid(ss,0:2,rr) - grid(ss,0:2,rr-1)),lnorm=2,/double))/chl
    ENDFOR
ENDFOR

FOR rr=1,m-1 DO BEGIN
    sum=0.0
    FOR ss=0,n DO sum += vvmat(ss,rr)
    vpar(rr) = sum/(nu)
ENDFOR



knots2=dblarr(m-q)


;/*====NON PERIODIC KNOTS ARRAY along V====*/;
 FOR kk=0,m-q-1 DO BEGIN
     sum=0.0;
     FOR hh=kk+1,kk+q DO sum += vpar(hh)
     knots2(kk)=(1/q)*sum
ENDFOR

av = dblarr(q+1)
bv = dblarr(q+1)
bv(*)=1D
v_knots=[av, knots2, bv]



knots={u_knots:u_knots, v_knots:v_knots, uu:upar, vv:vpar}

return, knots

END