FUNCTION L_vec2, distx,disty , tolerance=lim

;+
;  FUNCTION L_vec2, distx,disty,nx=nx,ny=ny
; 
;  calculates vectors Lu and Lv 
;
;  The purpose is to project the coefficients onto two given directions 
;  in order to define a smaller patch that contains the intersection point.
; 
; Inputs: 
;        distx: matrix with x coefficients
;        disty: matrix with y coefficients
; 
; Keywords: 
;	 tolerance: the "zero" value (default=1D-9)
;
; Method: 
;         computes Lu and Lv following the formula 4.17
;         Pag 43 in "Efficirnet Ray Tracing of Trimmed
;         NURBS Surfaces" Master Thesis by A. Efremov, 
;         Max Planck Institute fur Informatik, 2004
;
;-

nx= n_elements(distx(0,*))
ny= n_elements(disty(*,0))

lim=1d-9 ; zero

; it uses distances from first point to the last one
; (instead of 0 and 1 in given reference)
;
P00=[distx(0,0),disty(0,0)]
P01=[distx[0,nx-1],disty[0,nx-1]]
P10=[distx(ny-1,0),disty(ny-1,0)]
P11=[distx(ny-1,nx-1),disty(ny-1,nx-1)]
;

Lu =0.5*(P10 - P00 + P11 - P01)


Lu = Lu;/sqrt(total(Lu*Lu))

Lv =0.5*(P01 - P00 + P11 - P10)

Lv = Lv;/sqrt(total(Lv*Lv))

modlu=sqrt(total(Lu*Lu))
modlv=sqrt(total(Lv*Lv))

IF (modlu LE lim) and (modlv GT lim) then BEGIN
  lu=[-Lv[1],Lv[0]]
  message,/continue,'Found Lu vector equal to zero. Redefined'
ENDIF
;
IF (modlv LE lim) and (modlu GT lim) then BEGIN
  lv=[-Lu[1],Lu[0]]
  message,/continue,'Found Lv vector equal to zero. Redefined'
ENDIF
;
IF (modlv LE lim) and (modlu LE lim) then BEGIN
  message,/continue,'Found both Lu and Lv vectors equal to zero. Redefined'
  lv=[max(distx), max(disty)]
  lu=[max(distx), min(disty)]
ENDIF

;print, 'lu:',lu
;print, 'lv:',lv
;
;IF (modlu lt lim) and (modlv lt lim) then begin
;lu=P00
;lv=[Lu[1],-Lu[0]]
;ENDIF

L={Lu:Lu,Lv:Lv}

return,L

END
