PRO write_shadowsurface,zz1,xx,yy,file=file

;+
;
;       NAME:
;               WRITE_SHADOWSURFACE
;       PURPOSE:
;               This procedure writes a surface into a file with the 
;               shadow format (as defined for PRESURFACE, see SHADOW's doc)
;
;       CATEGORY:
;               SHADOW tools
;
;       CALLING SEQUENCE:
;               write_shadowsurface,zz1,xx,yy,file=file
;
; 	INPUTS:
;		zz1: The mesh array with the surface elevation z(x,y)
;		xx:  The array with the x points
;		yy:  The array with the y points
;	
; 	KEYWORD PARAMETERS
;		file: A string with the file name [default=presurface.dat]
;
;	AUTHOR: 
;		M. Sanchez del Rio srio@esrf.eu 
;	
;	MODIFICATION HISTORY:
;		2009-09-29 written
;
;-
on_error,2
;

IF type(zz1) EQ 8 THEN BEGIN ; structure input
 zz = zz1.z
 xx = zz1.x
 yy = zz1.y
ENDIF ELSE BEGIN
 zz = zz1
ENDELSE

sz = size(zz)
nx = sz[1]
ny = sz[2]

IF N_Elements(xx) EQ 0 THEN xx=makearray1(nx,-nx/2.0D0,nx/2.0D0)
IF N_Elements(yy) EQ 0 THEN yy=makearray1(ny,-ny/2.0D0,ny/2.0D0)
IF N_Elements(file) EQ 0 THEN file='presurface.dat'

  openw,Unit,file,/get_lun
    printf,Unit,nx,ny
    printf,Unit,yy
    for i=0,nx-1 do begin
      printf,Unit,xx[i],zz[i,*]
    endfor
  free_lun,Unit
  print,'File written to disk: ',file

END
