PRO write_gfile, str, file, json=json
;+
; NAME:
;	WRITE_GFILE
;
; PURPOSE:
;	This writes the contents of an IDL structure in a gfile.
;
; CATEGORY:
;	SHADOW
;
; CALLING SEQUENCE:
; 
;	write_gfile,str [,file]
;
; INPUTS:
;	str:	The IDL structure.
;
; OPTIONAL INPUTS:
;	file:	the file name for the output. If not set, it uses 'start.00'
;
; KEYWORD PARAMETERS:
;       JSON: Set this keyword to one to write json (www.json.org) format.
;
; OUTPUTS:
;	A gfile.
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;
;		WRITE_GFILE,str,'start.02'
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio, srio@esrf.fr, 97/11/05
;	98-06-24 srio@esrf.fr adds format when writing float/double.
;	06-02-21 srio@esrf.fr changes format to deal with meV
;	2013-12-11 srio@esrf.eu added json kw (first attempt!)
;-

;
; writes the start.00 file from the corresponding idl structure
; MSR 97/11/04
;
on_error,2
names = tag_names(str)
if keyword_set(file) then file1=file else file1='start.00' 
openw,Unit,file1,/Get_lun
if keyword_set(json) EQ 1 then strequal=':' else strequal=' = '
if keyword_set(json) EQ 1 then strcomma=',' else strcomma=''
if keyword_set(json) EQ 1 then c='"' else c=''
if keyword_set(json) EQ 1 then printf,unit,'{'
for i=0,n_tags(str)-1 do begin
  nn = n_elements(str.(i))
  mytype = type(str.(i))
  if nn EQ 1 then begin
     if mytype EQ 4 or mytype EQ 5 then begin  ; float or double
       printf,Unit,c+names(i)+c+strequal+string(str.(i),format='(G17.9)')+strcomma  
     endif else begin
       if ((mytype eq 7) and (keyword_set(json) eq 1)) then cc='"' else cc=''
       printf,Unit,c+names(i)+c+strequal+cc+strcompress(str.(i))+cc+strcomma
     endelse
  endif else begin 
    for j=0,nn-1 do begin
       if mytype EQ 4 or mytype EQ 5 then begin ; float or double
         printf,Unit,c+names(i)+'('+strcompress(j+1,/rem)+$
	  ')'+c+strequal+string((str.(i))(j),format='(G15.8)')+strcomma 
       endif else begin
         ; add quotes if string for json output
         if ((mytype eq 7) and (keyword_set(json) eq 1)) then cc='"' else cc=''
         printf,Unit,c+names(i)+'('+strcompress(j+1,/rem)+$
	  ')'+c+strequal+cc+strcompress((str.(i))(j))+cc+strcomma
       endelse
    endfor
  endelse
endfor
if keyword_set(json) EQ 1 then begin
    printf,unit,'"JUNK4JSON":0'
    printf,unit,'}'
endif
free_lun,Unit
message,/info,'File '+file1+' written to disk.'
end

