; 
;===============================================================================
;
Pro xshoe_fmirr,oestr,FMIRR=FMIRR,GROUP=group,ACTION=action

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_FMIRR: Error caught: '+$
	!err_string,/error)
   return
endif

if not(keyword_set(fmirr)) then fmirr = 5 
case fmirr of
  1: kind_oe = 'Spherical'
  2: kind_oe = 'Ellipsoidal'
  3: kind_oe = 'Toroidal'
  4: kind_oe = 'Paraboloid'
  5: kind_oe = 'Plane'
  6: kind_oe = 'Codling Slit'
  7: kind_oe = 'Hyperboloid'
  8: kind_oe = 'Cone'
  9: kind_oe = 'Polynomial'
  10: kind_oe = 'Conic coefficients'
endcase


if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')

;
; INTERNAL str
;
titles_internal = ['Focii and Continuation Planes',$
  'Object side focal distance [cm]',$
  'Image side focal distance [cm]',$
  'Incidence angle respect to the normal [deg]',$
  'File with SPLINE/ POLYNOMIAL',$
  'Focus location',$
  'Toroidal mirror pole location',$
  'Codling Slit length [cm]',$
  'Codling Slit width [cm]' ] 
flags_internal = ['1',$
  'w(0) EQ 0',$
  'w(0) EQ 0',$
  'w(0) EQ 0',$
  '0', $	; 4 File with SPLINE/ POLYNOMIAL
  '0', $	; 5 Focus location
  '0', $	; 6 Toroidal mirror pole location
  '0', $	; 7 Codling Slit length
  '0'] 		; 8              width
case fmirr of
  1: 			  ;'>>>>>> spherical <<<<<<'
  2: 			  ;'>>>>>> elliptical <<<<<<'
  3: flags_internal[6] = '1' ;'>>>>>> toroidal <<<<<<'
  4: flags_internal[5] = '1' ;parabolical
  5: 			     ;'>>>>>> plane <<<<<<'
  6: BEGIN
	flags_internal[7:8] = '1' ;'>>>>>> codling slit <<<<<<'
	flags_internal[0:3] = '0' ;'>>>>>> codling slit <<<<<<'
	END
  7: 			  ;'>>>>>> hyperbolical <<<<<<'
  8: 			  ;'>>>>>> cone <<<<<<'
  9: BEGIN
	flags_internal[4] = '1'   ;'>>>>>> polynomial <<<<<<'
	flags_internal[0:3] = '0' ;'>>>>>> polynomial <<<<<<'
	END
  10: 			  ;'>>>>>> conic coeffs <<<<<<'
endcase
INTERNAL = { F_DEFAULT:[strcompress(oestr.F_DEFAULT,/Rem),'Different',$
	'Coincident'],$
   SSOUR:oestr.SSOUR, $
   SIMAG:oestr.SIMAG, $
   THETA:oestr.THETA, $
   FILE_MIR:oestr.FILE_MIR, $
   F_SIDE:[strcompress(oestr.F_SIDE,/Rem),'Image','Source'],$ ; fmirr=4
   F_TORUS:[strcompress(oestr.F_TORUS,/rem),'lower/outer (concave/concave)',$
	'lower/inner (concave/convex)','upper/inner (convex/concave)', $
	'upper/outer (convex/convex)'], $ ; for fmirr=3
   COD_LEN:oestr.COD_LEN, $
   COD_WID:oestr.COD_WID, $
   FLAGS:flags_internal, $
   TITLES:titles_internal, $
   WTITLE:'Mirror Parameters (internal)', $
   NOTYPE:1, $
   INTERPRET:1 }
;
; EXTERNAL str
;
titles_external = ['Spherical radius [cm]',$	; 0
  'Ellipse/Hyperbola semi-major Axis [cm]',$		; 1
  'Ellipse/Hyperbola semi-minor Axis [cm]',$		; 2
  'Angle of MajAx and Pole [CCW] [deg]',$	; 3
  'Paraboloid param.',$			; 4
  'Torus major Radius [cm]',$		; 5
  'Torus minor Radius [cm]',$		; 6
  'Toroidal mirror pole location',$
  'Cone half-aperture [deg]' ]		; 7

flags_external = replicate('0',n_elements(titles_external))
case fmirr of
  1: flags_external[0] = '1' ;'>>>>>> spherical <<<<<<'
  2: flags_external[1:3] = '1' ;'>>>>>> elliptical <<<<<<'
  3: flags_external[5:7] = '1' ;'>>>>>> toroidal <<<<<<'
  4: flags_external[4] = '1' ;'>>>>>> parabolical <<<<<<'
  5: 			     ;'>>>>>> plane <<<<<<'
  6: 			     ;'>>>>>> codling slit <<<<<<'
  7: flags_external[1:3] = '1' ;'>>>>>> hyperbolical <<<<<<'
  8: flags_external[8] = '1' ;'>>>>>> cone <<<<<<'
  9: 			      ;'>>>>>> polynomial <<<<<<'
  10: 			      ;'>>>>>> conic coeffs <<<<<<'
endcase
EXTERNAL = {    RMIRR:oestr.RMIRR, $
   AXMAJ:oestr.AXMAJ, $
   AXMIN:oestr.AXMIN, $
   ELL_THE:oestr.ELL_THE, $
   PARAM:oestr.PARAM, $
   R_MAJ:oestr.R_MAJ, $
   R_MIN:oestr.R_MIN, $
   F_TORUS:[strcompress(oestr.F_TORUS,/rem),'lower/outer (concave/concave)',$
	'lower/inner (concave/convex)','upper/inner (convex/concave)', $
	'upper/outer (convex/convex)'], $ ; for fmirr=3
   CONE_A:oestr.CONE_A, $
   FLAGS:flags_external, $
   TITLES:titles_external, $
   WTITLE:'Mirror parameters (external)', $
   NOTYPE:1, $
   INTERPRET:1 }
;
; REFLEC str
;
titles_reflec = [ 'Source of Reflectivity',$
  'File name',$
  'Mlayer thickness vary as cosine',$
  'Alpha [epsilon = (1-alpha)+i gamma]',$
  'Gamma [epsilon = (1-alpha)+i gamma]' ]
flags_reflec = [ '1',$  ;  0: file/tt/mlayer
  'w(0) EQ 0 OR w(0) EQ 2',$  ; File name
  'w(0) EQ 2',$  ; Mlayer thick. vary as cosine
  'w(0) EQ 1',$  ; Alfa
  'w(0) EQ 1' ]  ; Gamma

REFLEC = { F_REFL:[strcompress(oestr.F_REFL,/Rem), $
         'file generated by PREREFL (mirror)',$
	 'Electric susceptibility (mirror)',$
         'file generated by pre_mlayer (multilayers)'],$
   FILE_REFL:oestr.FILE_REFL, $
   F_THICK:[strcompress(oestr.F_THICK,/Rem),'No','Yes'],$
   ALFA:oestr.ALFA, $
   GAMMA:oestr.GAMMA, $
   FLAGS:flags_reflec, $
   TITLES:titles_reflec,$
   WTITLE:'Optical Constants',$
   NOTYPE:1, $
   INTERPRET:1 }
;
; SHAPE str
;
titles_shape = ['Shape selected',$
  'X(+) Half Width / Int Maj Ax [cm]',$
  'X(-) Half Width / Ext Maj Ax [cm]',$
  'Y(+) Half Width / Int Min Ax [cm]',$
  'Y(-) Half Width / Ext Min Ax [cm]']
flags_shape = replicate('1',n_elements(titles_shape))
SHAPE = {    FSHAPE:[strcompress(oestr.FSHAPE-1,/Rem),'Rectangular',$
	'Full ellipse','Ellipse with hole'],$
  RWIDX1:oestr.RWIDX1, $
  RWIDX2:oestr.RWIDX2, $
  RLEN1:oestr.RLEN1, $
  RLEN2:oestr.RLEN2, $
  FLAGS:flags_shape,$
  TITLES:titles_shape,$
  WTITLE:'Mirror Shape & Dimensions',$
  NOTYPE:1, $
  INTERPRET:1 }

;
; CONIC Coeffs str
;
titles_ccc = ['c[1]','c[2]','c[3]','c[4]','c[5]','c[6]','c[7]','c[8]','c[9]','c[10]']
flags_ccc = replicate('1',n_elements(titles_ccc))
CCC = { $
  ccc1:oestr.ccc[0], $
  ccc2:oestr.ccc[1], $
  ccc3:oestr.ccc[2], $
  ccc4:oestr.ccc[3], $
  ccc5:oestr.ccc[4], $
  ccc6:oestr.ccc[5], $
  ccc7:oestr.ccc[6], $
  ccc8:oestr.ccc[7], $
  ccc9:oestr.ccc[8], $
  ccc10:oestr.ccc[9], $
  FLAGS:flags_ccc, $
  TITLES:titles_ccc, $
  WTITLE:'Conic coefficients',$
  NOTYPE:1,$
  INTERPRET:1 }
;
; main window
;
titles=[ 'Surface shape parameters',$
  'INTERNAL pars...',$
  'EXTERNAL pars...',$
  'Surface curvature',$
  'Cylindrical',$
  'Cylinder orient. [deg] [CCW from X axis]',$
  'Reflectivity',$
  'REFL pars...',$
  'Limits check',$
  'o.e. DIMENSIONS...',$
  'Conic coeffs...']
flags = ['1',$   ; 0 Mirror parameters
  'w(0) EQ 0',$  ; 1 INTERNAL str
  'w(0) EQ 1',$  ; 2 EXTERNAL str
  '1',$  ; 3 Surface curvature 
  '1',$  ; 4 Cylindrical
  'w(4) EQ 1',$  ; 5 orient
  '1',$  ; 6 Reflectivity
  'w(6) GE 1',$  ; 7 REFLEC str
  '1',$  ; 8 Limits
  'w(8) EQ 1', $ ; 9 SHAPE str
  '0'] ; 10 CCC str

case fmirr of
  1:			;'>>>>>> spherical <<<<<<'
  2:			;'>>>>>> elliptical <<<<<<'
  3:			;'>>>>>> toroidal <<<<<<'
  4:			;'>>>>>> parabolical <<<<<<'
  5:  flags[0:5]='0'	;'>>>>>> plane <<<<<<'
  6:  flags[0:2] = ['0','1','0'] ;'>>>>>> codling slit <<<<<<'
  7:			;'>>>>>> hyperbolical <<<<<<'
  8:			;'>>>>>> cone <<<<<<'
  9:  flags[0:2] = ['0','1','0'] ;'>>>>>> polynomial <<<<<<'
  10:  flags[[0,1,2,4,5,10]] = ['0','0','0','0','0','1'] ;'>>>>>> conic coeffs <<<<<<'
  else:
endcase
 
tmp =    { F_EXT:[strcompress(oestr.F_EXT,/Rem),'internal/calculated',$
	'external/user defined'],$
  INTERNAL:internal,$
  EXTERNAL:external,$
  F_CONVEX:[strcompress(oestr.F_CONVEX,/Rem),'Concave','Convex'],$
  FCYL:[strcompress(oestr.FCYL,/Rem),'No','Yes'],$
  CIL_ANG:oestr.CIL_ANG,$
  F_REFLEC:[strcompress(oestr.F_REFLEC,/Rem),'Not considered',$
	'Full polarization dependence','No pol. dep. (scalar)'],$
  REFLEC:reflec,$
  FHIT_C:[strcompress(oestr.FHIT_C,/Rem),'Infinite o.e. dimensions',$
	'Finite o.e. dimensions'],$
  SHAPE:shape, $
  CCC:ccc }


;
;
;

action=0
XWMenu,tmp,/NOTYPE,/INTERPRET,wtitle=kind_oe+' O.E. specifications',$
  FLAGS=flags,TITLES=titles,ACTION=action,GROUP=group,NCOL=1

if action eq 'DONT' then return

;
; copy the results on the old structure
;

; INTERNAL
oestr.F_DEFAULT = fix( tmp.internal.F_DEFAULT(0) )
oestr.SSOUR = tmp.internal.SSOUR
oestr.SIMAG = tmp.internal.SIMAG
oestr.THETA = tmp.internal.THETA
oestr.FILE_MIR = tmp.internal.FILE_MIR
oestr.F_SIDE = fix(tmp.internal.F_SIDE(0))
oestr.F_TORUS = fix(tmp.internal.F_TORUS(0))
oestr.COD_LEN = tmp.internal.COD_LEN
oestr.COD_WID = tmp.internal.COD_WID
; EXTERNAL
oestr.RMIRR = tmp.external.RMIRR
oestr.AXMAJ = tmp.external.AXMAJ
oestr.AXMIN = tmp.external.AXMIN
oestr.ELL_THE = tmp.external.ELL_THE
oestr.PARAM = tmp.external.PARAM
oestr.R_MAJ = tmp.external.R_MAJ
oestr.R_MIN = tmp.external.R_MIN
oestr.F_TORUS = fix(tmp.external.F_TORUS(0))
oestr.CONE_A = tmp.external.CONE_A
; REFLEC
oestr.F_REFL = fix(tmp.reflec.F_REFL(0))
oestr.FILE_REFL = tmp.reflec.FILE_REFL
oestr.F_THICK = fix(tmp.reflec.F_THICK(0))
oestr.ALFA = tmp.reflec.ALFA
oestr.GAMMA = tmp.reflec.GAMMA
; SHAPE
oestr.FSHAPE = fix(tmp.shape.FSHAPE(0))+1
oestr.RWIDX1 = tmp.shape.RWIDX1
oestr.RWIDX2 = tmp.shape.RWIDX2
oestr.RLEN1 = tmp.shape.RLEN1
oestr.RLEN2 = tmp.shape.RLEN2
; CCC
oestr.ccc[0] = tmp.ccc.ccc1
oestr.ccc[1] = tmp.ccc.ccc2
oestr.ccc[2] = tmp.ccc.ccc3
oestr.ccc[3] = tmp.ccc.ccc4
oestr.ccc[4] = tmp.ccc.ccc5
oestr.ccc[5] = tmp.ccc.ccc6
oestr.ccc[6] = tmp.ccc.ccc7
oestr.ccc[7] = tmp.ccc.ccc8
oestr.ccc[8] = tmp.ccc.ccc9
oestr.ccc[9] = tmp.ccc.ccc10
; MAIN
oestr.F_EXT = fix(tmp.F_EXT(0))
oestr.F_CONVEX = fix(tmp.F_CONVEX(0))
oestr.FCYL = fix(tmp.FCYL(0))
oestr.CIL_ANG = tmp.CIL_ANG
oestr.F_REFLEC = fix(tmp.F_REFLEC(0))
oestr.FHIT_C = fix(tmp.FHIT_C(0))

return
end

