Pro xsh_prerefl,inp,Group=group

;+
; NAME:
;	XSh_PreRefl
;
; PURPOSE:
;	A driver for PreRefl
;
; CATEGORY:
;	SHADOW GUI
;	Widgets.
;
; CALLING SEQUENCE:
;	XSh_PreRefl
;
; OPTIONAL INPUTS:
;	inp: a structure with the input parameters.
;	
; KEYWORD PARAMETERS:
;	Group:	The ID of the caller Widget. It is used for the Dialog
;		windows to be positioned.
; OUTPUTS:
;	None.
;
; COMMON BLOCKS:
;	XSH_PREREFL_COMMON contains the data structure for next calls
;		of the application.
;
; SIDE EFFECTS:
;	Creates a temporary file (xsh_prerefl_tmp.inp) and runs 
;	prerefl.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Satraightforwerd.
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.fr
;	December 9, 1997
;
;-

COMMON xsh_prerefl_common,str1
common shadow3,shadow3_mode, shadow3_binary

IF N_Elements(inp) NE 0 THEN str1=inp ELSE $
  IF n_elements(str1) EQ 0 THEN $
    str1 = xsh_defaults_preprocessors('XSH_PREREFL')

action=''
str = str1.parameters
XScrMenu,str,Titles=str1.titles,/Notype,Action=action,/Interp,NCol=2,$
 WTitle='PreRefl inputs',Help=str1.help_text
IF action EQ 'DONT' THEN Return
str1.parameters = str

IF shadow3_mode EQ 0 THEN BEGIN
  Openw,unit,'xsh_prerefl_tmp.inp',/Get_Lun
ENDIF ELSE BEGIN
  Openw,unit,'shadow3.inp',/Get_Lun
  PrintF,unit,'prerefl'
ENDELSE
;
; parse the formula
;
sym = 0 & frac = 0
nn = parse_compound(str.Symbol,sym,frac)
IF nn EQ 1 THEN PrintF,unit,'0' ELSE PrintF,unit,'1'
;
; density
;
IF StrCompress(str.density(0),/Rem) EQ '?' THEN BEGIN
 density = 1.0
 IF nn EQ 1 THEN density = p_table(sym(0),/Density) ELSE $
	itmp = Dialog_Message(Dialog_Parent=group,$
	'I do not know the density for your compound. Set to 1') 
ENDIF ELSE density=str.density
PrintF,unit,StrCompress(density,/Rem)
;
; the symbol or formula
;
IF nn GT 1 THEN BEGIN
  PrintF,unit,StrCompress(nn,/Rem)
  FOR i=0,nn-1 DO BEGIN
    PrintF,unit,p_table(sym(i),/Shadow)
    PrintF,unit,StrCompress(fix(frac(i)),/Rem)
  ENDFOR
ENDIF ELSE BEGIN
  PrintF,unit,p_table(sym(0),/Shadow)
ENDELSE
;
; Energy
;
PrintF,unit,StrCompress(str.E_Min,/Rem)
PrintF,unit,StrCompress(str.E_Max,/Rem)
PrintF,unit,StrCompress(str.E_Step,/Rem)
;
;file
;
file = str.file
IF checkfile(file) THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group,/Question,$
	['File '+file+' exists.','Overwrite it?'])
  if itmp EQ 'No' then file = Dialog_Pickfile(/Write)
  if file EQ '' then begin
    itmp = Dialog_Message(Dialog_Parent=group,/Error,$
	'prerefl not run.')
    Free_Lun,unit
    return
  endif
ENDIF
PrintF,unit,file
IF shadow3_mode NE 0 THEN PrintF,unit,'exit'
Free_Lun,unit
IF shadow3_mode EQ 0 THEN BEGIN
  Xsh_Run,'prerefl < xsh_prerefl_tmp.inp'
ENDIF ELSE BEGIN
  Xsh_Run,shadow3_binary+' < shadow3.inp'
ENDELSE
; command  = '/bin/rm xsh_prerefl_tmp.inp'
; Message,/info,'Executing: '+command
; Spawn, command
END


