

Function xsh_histo1_command,PStr


command = 'histo1,' + $
  "'"+(*pstr).shadow_in+"'"+ $
  ','+StrCompress((*pstr).col,/Rem)

;IF (*pstr).default_xrange EQ 0 THEN BEGIN 
  IF (*pstr).xrange(0) NE (*pstr).xrange(1) THEN $
    command = command+',XRange='+$
    Vect2String([(*pstr).xrange(0),(*pstr).xrange(1)])
;ENDIF

;IF (*pstr).default_yrange EQ 0 THEN BEGIN 
  IF (*pstr).yrange(0) NE (*pstr).yrange(1) THEN $
    command = command+',YRange='+$
    Vect2String([(*pstr).yrange(0),(*pstr).yrange(1)])
;ENDIF

IF (*pstr).nolost NE 0 THEN $
  command = command + ',NoLost='+StrCompress((*pstr).nolost,/rem)

IF (*pstr).NBins NE 0 AND (*pstr).NBins NE 25 THEN $
  command = command + ',NBins='+StrCompress((*pstr).nbins,/Rem)
IF (*pstr).cm NE 0 THEN $
  command = command + ',CM='+StrCompress((*pstr).cm,/rem)
IF (*pstr).yLog NE 0 THEN $
  command = command + ',YLog='+StrCompress((*pstr).YLog,/rem)
IF (*pstr).calfwhm NE 0 THEN $
  command = command + ',CalFWHM='+StrCompress((*pstr).calfwhm,/rem)
IF (*pstr).calError NE 0 THEN $
  command = command + ',CalError='+StrCompress((*pstr).calError,/rem)
IF (*pstr).gaussfit NE 0 THEN $
  command = command + ',GaussFit='+StrCompress((*pstr).gaussfit,/rem)

IF (*pstr).reflectivity NE 0 THEN $
  command = command + ',Reflectivity='+StrCompress((*pstr).reflectivity,/rem)

IF (*pstr).write NE 0 THEN $
  command = command + ',Write='+StrCompress((*pstr).write,/rem)

IF (*pstr).publish NE 0 THEN $
  command = command + ',Publish='+StrCompress((*pstr).publish,/rem)

IF StrCompress((*pstr).title,/Rem) NE '' THEN $
  command = command+',Title='+"'"+(*pstr).title+"'"
IF StrCompress((*pstr).Xtitle,/Rem) NE '' THEN $
  command = command+',XTitle='+"'"+(*pstr).Xtitle+"'"
IF StrCompress((*pstr).Ytitle,/Rem) NE '' THEN $
  command = command+',YTitle='+"'"+(*pstr).Ytitle+"'"

Return,command

END
