;+
;
; FUNCTION vecscale,vector
;
; Written by D. Bianchi, ESRF, 2006
;
;//
;// Function Name:
;//
;//   vecscale - Transformation matrix for a scaling.
;//
;// Calling Sequence:
;//
;//   ss = vecscale(svec)
;//
;// Parameters:
;//
;//   svec    : A vectors defining the scaling along the x,y and z axes.
;//             i.e. [sx, sy, sy]
;//
;//   ss        : Scaling Transformation Matrix
;//
;// Description:
;//
;//   Returns a (4x4) Transformation matrix for scaling.
;//
;//   The matrix is:
;//
;//         [ sx  0   0   0]
;//         [ 0   sy  0   0]
;//         [ 0   0   sz  0]
;//         [ 0   0   0   1]
;//
;-

FUNCTION vecscale,vector
ss = double([[vector[0], 0, 0, 0], [0, vector[1], 0, 0], [0, 0, vector[2], 0], [0, 0, 0, 1]])

return, ss

END
