FUNCTION vecrotx, angle,deg=deg
;+
;
; FUNCTION vecrotx, angle,deg=deg
;
; Written by D. Bianchi, ESRF, 2006
;
;//
;// Function Name:
;//
;//   vecrotx - Transformation matrix for a rotation around the x axis.
;//
;// Calling Sequence:
;//
;//   rx = vecrotx(angle);
;//
;// Parameters:
;//
;//   angle     : rotation angle defined in radians
;//
;//   rx       : (4x4) Transformation matrix.
;//
;//
;// Description:
;//
;//   Return the (4x4) Transformation matrix for a rotation about the x axis
;//   by the defined angle.
;//
;//   The matrix is:
;//
;//         [ 1         0            0          0]
;//         [ 0     cos(angle)  -sin(angle)     0]
;//         [ 0     sin(angle)   cos(angle)     0]
;//         [ 0         0            0          1]
;//
;-


IF keyword_set(deg) THEN angle=angle*!dpi/180D

sn = sin(angle);
cn = cos(angle);

rx = double([[1, 0, 0, 0], [0, cn, -sn, 0], [0, sn, cn, 0], [0, 0, 0, 1]])

ind=where(abs(rx) LT 1e-6)
rx[ind]=0

return, rx

END
