
;LL = length of cylinder [cm] default=10
;ww = semiarc length [cm] default=20

;+
;
; FUNCTION nrbmakecylinder, rr,p=p,q=q,angle=angle,ll=ll, ww=ww
;
; ARGUMENTS
;
;   LL = longitudinal aperture (chord, default = 10)
;   WW = transversal aperture (chord, default = 5)
;
;   Define either:
;   RR = radius of cylinder [cm] default=3400
;   or:
;   P  = distance source-mirror
;   Q  = distance mirror-image
;   ANGLE  = Grazing incident angle [rad]
;   ELLIPTICAL = set this keyword, for generating an elliptical cylinder
; OUTPUT
;
;   MIRR = a NURBS structure of a cylinder (circular section)
;
;-
FUNCTION nrbmakecylinder, rr,p=p,q=q,angle=angle,ll=ll, ww=ww, elliptical=elliptical

IF n_elements(rr) EQ 0 THEN BEGIN
    IF n_elements(p) EQ 0 THEN p=3000
    IF n_elements(q) EQ 0 THEN q=1000
    IF n_elements(angle) EQ 0 THEN angle=5e-3
    rr = 2D0*p*q/(p+q)/sin(angle)
ENDIF


IF n_elements(ll) eq 0 THEN ll = 10d
IF n_elements(ww) eq 0 THEN ww = 10d

rr=double(rr)
ll=double(ll)
ww=double(ww)

alpha = asin(ll/2/rr) ;semiangular aperture of the mirror

alpha_s = -alpha ;start angle (see nrbcirc.pro)
alpha_e = alpha ;end angle (see nrbcirc.pro)

CASE elliptical OF
    0: BEGIN
        crf = __nrbcirc(rr,oo=[-rr,0d,0d],sang=alpha_s,eang=alpha_e)
        mat = vecroty(90d,/deg)
        temp=nrbtransform(crf,mat)

       END

    1: BEGIN
        crf = __nrbelliptical_arch(p=p,q=q,alpha=angle,ll=ll,x=x,y=y,y1)
        trans=vectrans([-x,-y,0d])
        rotz1=vecrotz(-atan(y1))
        rotx=vecrotx(!dpi/2)
        rotz2=vecrotz(!dpi/2)
        temp=nrbtransform(crf,rotz2##rotx##rotz1##trans)

       END
ENDCASE




temp=nrbextrude(temp,[ww,0d,0d]) ; extrusion of the arc along y direction


trans = vectrans([-ww/2,0d,0d])

srf=nrbtransform(temp,trans);rotz##

return, srf

END
