; Function figure of merit for minimalisation procedures

FUNCTION interminfom,x

;
; returns the distance of a parametric point (u,v) 
; to the nurbs surface
;


; common variables for intersection using minimization
COMMON intermin, _n0, _x0, _v0

IF (x[0] GT 1) THEN return, 1000*x[0]
IF (x[0] LT 0) THEN return, 1000*abs(x[0])
IF (x[1] GT 1) THEN return, 1000*x[1]
IF (x[1] LT 0) THEN return, 1000*abs(x[1])


z = nrbeval(_n0,x[0]<1>0,x[1]<1>0)


point = z[0:2]
;print,'point: ',point,x[0],x[1]

;
; calculate distance**2 from point (point, 3 coordinates) to the 
; ray, i.e., a straight line defined by _x0 and _v0 ( |_v0|=1)
; 
a = point-_x0
p = Total(a*_v0)  * _v0
b = a-p
dist1 = sqrt(Total(b*b))

RETURN, dist1
END

