FUNCTION __nrbtoroid, rs, rt, ll=ll, ww=ww
;+
; FUNCTION __nrbtoroid, rs, rt, ll=ll, ww=ww
;-

IF n_elements(rs) EQ 0 THEN rs = 8.
IF n_elements(rt) EQ 0 THEN rt = 300.
IF n_elements(ll) EQ 0 THEN ll = 10.
IF n_elements(ww) EQ 0 THEN ww = 2.

rs=double(rs)
rt=double(rt)
ll=double(ll)
ww=double(ww)


alpha_ww = asin(ww/rs) ;semiangular aperture of the mirror for the length of the mirror

alpha_s = -(!dpi/2 + alpha_ww) ;start angle (see __nrbcirc.pro)
alpha_e = -(!dpi/2 - alpha_ww) ;end angle (see __nrbcirc.pro)
alpha_ll= asin(ll/(rt+rs)) ;angular aperture of the mirror for the length of the mirror

crf = __nrbcirc(rs,oo=[0d,rs,0d],sang=alpha_s,eang=alpha_e) ;structure of the arc of circumference x-y system
;nrbplot, crf,10,10
matx1 = vecrotx(!dpi/2) ;rotation around the x axis
matx2 = vecrotx(-alpha_ll)
matrans = vectrans([0.,-ll,(rt+rs)*(1-cos(alpha_ll))])

temp=nrbtransform(crf,matrans##matx2##matx1) ;new arc structure in x-z system


toro = __nrbrevolve(temp,pnt=[0d,0d,rt+rs],vec=[1d,0d,0d],theta=2*alpha_ll)  ;revolution of the arc, around the z, axis


return, toro

END
