FUNCTION __nrbelliptical_arch, p=p,q=q, a=a,b=b,alpha=alpha,ll=ll,x=x,y=y,y1

IF n_elements(p) EQ 0 THEN p=3000d

p=double(p)

IF n_elements(q) EQ 0 THEN q=1000d

q=double(q)

IF n_elements(alpha) EQ 0 THEN alpha=5e-3
IF n_elements(a) EQ 0 THEN a = (p + q)/2
IF n_elements(b) EQ 0 THEN b = sqrt(p*q)*sin(alpha)
IF n_elements(ll) EQ 0 THEN ll=400d

ll=double(ll)
;=== semi-foci distance ===;
c = sqrt(a^2-b^2)

;===eccentricity===;
ec=c/a

;===intersection point===;
x=(a*p-(a^2))/c

y=-sqrt(2*a*p-p^2-b^2)*b/c


y1 = b*x/a/sqrt(a^2-x^2)
rotang=atan(y1)
mt=y1;atan(y1)
qt = -mt*x+y

p1 = 1d + mt^2
p2 = -2d*x*(1 + mt^2)
p3 = x^2*(1d + mt^2) - (ll/2D)^2

delta=sqrt(p2^2-4*p1*p3)
xrts=[-p2-delta,-p2+delta]/(2*p1)

xap=real_part(xrts(where(imaginary(xrts) eq 0)))
xap=[min(xap,max=mxap),mxap]

yrts=mt*xrts + qt

yap = -b/a*sqrt(a^2-xap^2)
xsph = sqrt(b^2-yap^2)

alpha_ll = atan(yap/xsph) ;semiangular aperture of the mirror for the length of the mirror

alpha_s = alpha_ll[0] ;start angle (see __nrbcirc.pro)
alpha_e = alpha_ll[1] ;end angle (see __nrbcirc.pro)


sph=__nrbcirc(b,sang=alpha_s,eang=alpha_e)
sc=vecscale([a/b,1,1])
elp=nrbtransform(sph,sc)

return, elp

end
