pro read_system_rays_file, system, file

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'read_system_rays_file: error caught: '+!error_state.msg)
   RETURN
ENDIF


pas=1
nb_module=system->count()
if nb_module gt 0 then begin

	; get the path files
;	fileB=byte(file)
;	s=size(fileB)
;	n=s[1]
;	p=n-1
;	while (fileB[p] ne 92) and (p gt 0) do begin
;		p=p-1
;	endwhile
;	if p eq 0 then return
;	path=string(fileB[0:p])

	for module=0, nb_module-1 do begin
		optic=system->get_module(pos=module)

		optic->getProperty, planesSource=cps
		ps=cps->get(pos=0)
		ps->getProperty, beam_file=beam_file
		Result = CheckFile(beam_file)
		if result eq 1 then rays_source=read_rays_file(beam_file) else begin
			diag = DIALOG_MESSAGE("File is missing to read data",/INFORMATION)
			return
			endelse
		optic->setProperty, rays_source=rays_source

		optic->getProperty, planeElement=pe
		pe->getProperty, beam_file=beam_file
		Result = CheckFile(beam_file)
		if result eq 1 then rays_element=read_rays_file(beam_file) else begin
			diag = DIALOG_MESSAGE("File is missing to read data.",/INFORMATION)
			return
			endelse
		optic->setProperty, rays_element=rays_element

		optic->getProperty, planesImage=cpi
		pi=cpi->get(pos=0)
		pi->getProperty, beam_file=beam_file
		Result = CheckFile(beam_file)
		if result eq 1 then rays_image=read_rays_file(beam_file) else begin
			diag = DIALOG_MESSAGE("File is missing to read data",/INFORMATION)
			return
			endelse
		optic->setProperty, rays_image=rays_image

	endfor
endif
end
