;+
; NAME:
;       blv_image_processing
;
; PURPOSE:
;       This function creates a modal widget base with all the widget element 
;		necessary to
;		create an image thanks to a plane.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;	blv_image_processing, parent, plane
;
; INPUTS:
;       parent: a widget base used as parent.
;		plane: a 'plane' object. The image processing will be apply 
;			on the image extract from its beam.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-

pro blv_image_processing_event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_image_processing_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


Widget_Control,event.id, Get_UValue=uvalue

CASE uvalue OF
	'LOAD_BITMAP': BEGIN
		;purpose : opens a dialogue box to lets the user chose a *.Tif file and read the picture.
		forward_function DIALOG_READ_IMAGE
		widget_control, event.top, get_uvalue=pInfoImage
	
		IF Float(!version.release) LE 5.2 THEN BEGIN
		  file=dialog_pickfile(title='Open JPeg Image...', Filter='*.jpg', $
					/read, DIALOG_PARENT=(*pInfoImage).wBase)
		  IF file EQ '' THEN result=0 ELSE result=1
		  IF result NE 0 THEN read_JPeg,file,im
		  ; itmp = Dialog_Message(/Info, $
		  ; 'Sorry: Option not implemented in the current version of IDL : '+$
		  ;               !version.release)
		  ;result=0
		ENDIF ELSE BEGIN
		  result= DIALOG_READ_IMAGE (image=im, DIALOG_PARENT=(*pInfoImage).wBase )
		ENDELSE
		if result eq 0 then return
		IF (size(im))[0] EQ 3 THEN im=greyScale_image(im)
		image = CONGRID( im, 256, 256)
		(*pInfoImage).imageTab=image
		obj_destroy,(*pInfoImage).image
		(*pInfoImage).image=obj_new('idlgrimage', (*pInfoImage).imageTab, /Greyscale,dimensions=[1, 1])
		(*pInfoImage).model->add, (*pInfoImage).image
		(*pInfoImage).win->draw, (*pInfoImage).view
		END


	'MAKE_BITMAP': BEGIN
		;purpose : call the blv_beam_to_image function
		widget_control, /HOURGLASS
		widget_control, event.top, get_uvalue=pInfoImage
		(*pInfoImage).plane->getProperty, rays=beam, z=xRep, x=yRep
		n=beam->count()
		IF n EQ 0 THEN BEGIN
		itmp = Dialog_Message(Dialog_Parent=event.top,/Error,$
		['This plane contains no rays.',$
		 'Please close the BLViewer image processing window and use: ',$
		 '1) The "Load" button under the Rays controls, or ',$	
		 '2) The "(Re)Load Beam Data" button under the Plane controls',$
		 '  Note: In the case of creating images from non mandatory optical planes',$
		'         (i.e., from SHADOW screen.xxyy files), the second option must be used.'])

		RETURN
		ENDIF
		widget_control, (*pInfoImage).wTypeGroup, get_value=index
		case index of
			0: begin
				select=0
				good=1
				end
			1: begin
				select=1
				good=1
				end
			2: begin
				select=1
				good=0
				end
		endcase
		
		; calculate limits
		IF tag_names(event,/Structure_Name) EQ 'WIDGET_BUTTON' THEN BEGIN

		  beam->GetLimits,XRange=xRange,yRange=yrange,ZRange=zRange
		
		  diffx=Abs((xrange[1]-xrange[0])/10.0 > 0.001)
		  ;diffy=Abs((yrange[1]-yrange[0])/10.0 > 0.001)
		  ;diffz=Abs((zrange[1]-zrange[0])/10.0 > 0.001)

		  ; this part should be checked srio 10/10/01
		  range1=xrange+[-diffx,diffx] 
		  IF xRep EQ 2 THEN BEGIN
			range2=zRange 
			;range2=zrange+[-diffz,diffz] 
		  ENDIF ELSE BEGIN
			range2=yRange
			;range2=yrange+[-diffy,diffy] 
		  ENDELSE
		  myrange = [min( [range1[0],range2[0]] ) , $
			   max( [range1[1],range2[1]] ) ]
		  myrange=myrange*1.2
		  Widget_Control,(*pInfoImage).wWidth,Set_Value=Vect2String(myrange)
		ENDIF ELSE BEGIN ; 'WIDGET_TEXT_CH
		  Widget_Control,(*pInfoImage).wWidth,Get_Value=myval
		  itmp = Execute('myrange = '+myval[0])
		  IF itmp EQ 0 THEN BEGIN
		    tmp = Dialog_Message(/Error, Dialog_Parent=event.top, 'Not a valid range: '+myval)
		    RETURN
		  ENDIF
		  Widget_Control,(*pInfoImage).wWidth,Set_Value=Vect2String(myrange)
		ENDELSE




		;
		;srio newImage=blv_beam_to_image(beam,imageTab=imageTab,xrange=[-0.23,0.23],yrange=[-0.23,0.23], $
		newImage=blv_beam_to_image(beam,imageTab=imageTab,xrange=myrange,yrange=myrange, $
				xRep=xRep,yRep=yRep, select=select, good=good)
		(*pInfoImage).imageTab=imageTab
		obj_destroy,(*pInfoImage).image
		(*pInfoImage).image=newImage
		(*pInfoImage).model->add, newImage
		(*pInfoImage).win->draw, (*pInfoImage).view
		END


	'SMOOTH': BEGIN
		;purpose: make image processing on the current image on screen
		widget_control, /HOURGLASS
		widget_control, event.top, get_uvalue=pInfoImage
		imageTab=(*pInfoImage).imageTab
		;smooth*
		eps=20
		resu1=smooth( imageTab,eps)
		
		s=size(resu1)
		sx=s[1]
		sy=s[2]
		resu1[*,0:eps]=0
		resu1[*,sy-(eps+1):sy-1]=0
		resu1[0:eps,*]=0
		resu1[sx-(eps+1):sx-1,*]=0
		;median*
		epm=10
		resu2=median( resu1,epm)
		maxi=max(resu2)
		resu2=resu2*uint(255./maxi)
		
		(*pInfoImage).imageTab=resu2
		
		obj_destroy,(*pInfoImage).image
		
		(*pInfoImage).image=obj_new('idlgrimage',resu2, /Greyscale,dimensions=[1,1])
		(*pInfoImage).model->add, (*pInfoImage).image
		(*pInfoImage).win->draw, (*pInfoImage).view
		
		END

	'ACCEPT': BEGIN
		;change the picture of the plane given in parameter with the current image on screen
		widget_control, event.top, get_uvalue=pInfoImage
		
		(*pInfoImage).plane->set_image,(*pInfoImage).imageTab
		
		obj_destroy, (*pInfoImage).model
		obj_destroy, (*pInfoImage).view
		obj_destroy, (*pInfoImage).image
		
		widget_control, event.top, /destroy
		END

	'SAVEAS': BEGIN
		;purpose : save the current image on screen as *.tif file
		forward_function  DIALOG_WRITE_IMAGE
		widget_control, event.top, get_uvalue=pInfoImage
		
		IF Float(!version.release) LE 5.2 THEN BEGIN
		  file=dialog_pickfile(title='Open JPeg Image...',Filter='*.jpg', $
					/Write, DIALOG_PARENT=(*pInfoImage).wBase)
		  IF file EQ '' THEN RETURN
		  Write_JPeg,file,(*pInfoImage).imageTab
		  ;itmp = Dialog_Message(/Info, $
		  ;'Sorry: Option not implemented in the current version of IDL : '+$
		  ;              !version.release)
		ENDIF ELSE BEGIN
		   Result = DIALOG_WRITE_IMAGE ((*pInfoImage).imageTab ,DIALOG_PARENT=(*pInfoImage).wBase)
		ENDELSE
		END
	'CANCEL': BEGIN
		; purpose: close the modal widget without effect
		widget_control, event.top, get_uvalue=pInfoImage
		obj_destroy, (*pInfoImage).model
		obj_destroy, (*pInfoImage).view
		obj_destroy, (*pInfoImage).image
		
		widget_control, event.top, /destroy
		END


	else:
ENDCASE
END

;
;===============================================================================
;
pro blv_image_processing, parent, plane

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_image_processing: error caught: '+!error_state.msg)
   RETURN
ENDIF


IF N_Elements(parent) EQ 0 THEN parent=0L

IF Widget_Info(parent,/Valid_Id) THEN $
  wBase=widget_base(GROUP_LEADER=parent, /col, title='Image Processing',/floating,/modal) ELSE $
  wBase=widget_base(/col, title='Image Processing') 

	wtempBase=widget_base(wBase, /row)
	  wApply=widget_button(wtempBase, value='Apply',UValue='ACCEPT')
	  wCancel=widget_button(wtempBase, value='Cancel', UValue='CANCEL')
	wtempBase=widget_base(wBase, /row)
	  wCreate=widget_button(wtempBase, value='Make bitmap with rays', UValue='MAKE_BITMAP')
	  wProcess=widget_button(wtempBase, value='Smooth',UValue='SMOOTH')
	wtempBase=widget_base(wBase, /row)
	  wLoad=widget_button(wtempBase, value='Load image file', UValue='LOAD_BITMAP')
	  wSave=widget_button(wtempBase, value='Save As...',UValue='SAVEAS')

   	wdraw=widget_draw(wBase,XSIZE=200, YSIZE=200, GRAPHICS_LEVEL=2)

	wtempBase=widget_base(wBase, /row)
	wTypeChoice=widget_base(wtempBase,/col,/align_right)
			radioType=['All Rays', 'Good Only', 'Lost Only' ]


	 	wTypeGroup=CW_BGROUP(wTypeChoice, radioType, SET_VALUE=0, $
               	        /Col,/RETURN_INDEX, /EXCLUSIVE, /NO_RELEASE, uValue='wTypeGroup')

	wtempBase=widget_base(wBase, /row)
	  wTmp=widget_label(wtempBase, Value='Image size: ')
	  wWidth=widget_text(wtempBase, Value='[0,0]',/Editable, UValue='MAKE_BITMAP')

model=obj_new('idlgrmodel')
view=obj_new('idlgrview')
view->add, model
view->setProperty, VIEWPLANE_RECT=[0,0,1,1]

widget_control, wBase, /realize
widget_control, wdraw, get_value=win


IF N_Elements(plane) EQ 0 THEN BEGIN
  plane=OBJ_NEW('optical_plane')
  clean_plane=1
ENDIF ELSE BEGIN
  clean_plane=0
ENDELSE
imageTab=plane->get_image()
image=obj_new('idlgrimage',imageTab, /Greyscale,dimensions=[1,1])
model->add, image
win->draw, view
pInfoImage=ptr_new({wBase:wBase, wWidth:wWidth, $
					win:win, $
					plane:plane, $
					view:view, $
					model:model, $
					image:image, $
					imageTab:imageTab, $
					wTypeGroup:wTypeGroup $
					})

widget_control, wBase, set_uvalue=pInfoImage

xmanager, 'blv_image_processing', wBase

IF clean_plane EQ 1 THEN Obj_Destroy,plane

END
