Function xsh_defaults_preprocessors,program

CASE strupcase(program) OF
  'XSH_PREREFL': BEGIN
   help_text = [ ' ',$
   "This is the fron-end for the SHADOW's prerefl pre-processor.",$
   ' ',$
   'A qustion mark "?" for the density value is accepted when using',$
   'a single element.',$
   ' ',$
   'The Compound formula can go up to 5 elements.',' ',$
   'VERY IMPORTANT: The symbols must be typed in their usual way: ',$
   '  The first letter capitalized and the second letter (if needed) ',$
   '  in lower case (This was not the case of the original SHADOW prerefl).']

    parameters = { Symbol:'SiC',$
	density:'3.217',$
	file:'reflec.dat',$
	E_Min:100.0,$
	E_Max:20000.0,$
	E_Step:100.0}

    titles= [$
	'Element/Compound formula', 'Density [ g/cm3 ]',$
	'File for SHADOW (trace):',$
	'Minimum energy [eV]','Maximum energy [eV]',$
	'Energy step [eV]']
  out = { help_text:help_text,parameters:parameters,titles:titles }
  END
  'XSH_PRE_MLAYER':BEGIN
   help_text = [ ' ',$
   "This is the fron-end for the SHADOW's pre_mlayer pre-processor.",$
   ' ',$
   'A qustion mark "?" for the density value is accepted when using',$
   'a single element.',$
   ' ',$
   'The Compound formula can go up to 5 elements.',$
   ' ',$
   'In the case that graded multilayer is selected, the layers are read',$
   'from a file containg N lines (n=number of bi-layers) and each line',$
   'contains the bilayer thickness and the gamma ratio.']
     titles=['Output file (for SHADOW/trace): ',$
	'Min Energy [eV]',$
	'Max Energy [eV]',$
	'Density (substrate) [g/cm3]',$
	'Material (substrate)',$
	'Density (even layer) [g/cm3]',$
	'Material (even layer)',$
	'Density (odd layer) [g/cm3]',$
	'Material (odd layer)',$
	'Number of layer pairs ',$
	'Layer thicknesses ',$
	'bilayer thickness t [A]',$
	'gamma ratio [t_even/(t_odd+t_even)]',$
	'File with layer thicknesses']
     flags = [replicate('1',11),'w(10) EQ 0','w(10) EQ 0','w(10) EQ 1']
     parameters={file:'reflec.dat', $
	e_min:200.0,$
	e_max:500.0,$
	s_density:'2.32', s_material:'Si',$
	e_density:'19.3', e_material:'W',$
	o_density:'2.26', o_material:'C',$
	n_pairs:20,$
	type_thickness:['0','Constant','Graded'],$
	thickness:22.27,$
	gamma:0.35,$
	file_thickness:'mythick.dat' }
     out = {parameters:parameters, titles:titles, help_text:help_text,$
	flags:flags}
   END
  'XSH_BRAGG':BEGIN
   help_text = [ ' ',$
   "This is the fron-end for the SHADOW's bragg pre-processor.",$
   ' ']
		titles = [ $
		'Structure type',	$
		'Lattice cte a',	$
		'Lattice cte c',	$
		'H miller index',	$
		'K miller index',	$
		'L miller index',	$
		'Symbol 1st element',	$
		'Symbol 2nd element',	$
		'Absorption',	$
		'Temperature factor',	$
		  'From Energy [eV]', $
		  'To Energy to [eV]', $
		  'Energy step [eV]', $
		  'File name (for SHADOW)',$
		  'Calculate Diffraction Profile?',$
		'Mosaic',	$
		'Geometry and mode',	$
		'Photon energy (eV)',	$
		'Mosaic fwhm (deg):',	$
		'Thickness (cm) ',	$
		'Asymmetric angle (deg)',	$
		'Angular range (microrads)',	$
		'Number of points',	$
		'Angular Units',	$
		'Centered curve',$
		'Ask for ionic states in F0 table?' ]
		flags = [ $
		'1',	$			; structure (0)
		'1',	$
		'w(0) EQ 4 OR w(0) EQ 5',$	; c lattice cte
		'1',	$
		'1',	$
		'1',	$
		'1',	$
		'w(0) EQ 0 OR w(0) EQ 1 OR w(0) EQ 3',$	; 2nd symbol
		'1',	$
		'1',	$
		  '1',$
		  '1',$
		  '1',$
		  '1',$
		  '1',$
		'w(14) EQ 1',	$			;mosaic (10+5)
		'w(14) EQ 1',	$
		'w(14) EQ 1',	$
		'w(14) EQ 1 and w(15) EQ 1',$		; mosaic fwhm
		'w(14) EQ 1 and w(16) NE 2',	$
		'w(14) EQ 1 and w(15) EQ 0',$		; asymmetry angle
		'w(14) EQ 1',	$
		'w(14) EQ 1',	$
		'w(14) EQ 1',	$
		'w(14) EQ 1',$
		'1']
		out	  =  { titles:titles, flags:flags, help_text:help_text,$
		parameters:{ $ 
		Structure: ['0','ZincBlende','Rocksalt','simple FCC', $
		  'CsCl structure','Hexagonal Close-Packed',  $
		  'Hexagonal Graphite'] , $
		Lattice_Cte_a: 5.43094,$
		Lattice_Cte_c: 1.0, $
		h_miller_index: 1, $
		k_miller_index: 1, $
		l_miller_index: 1, $
		Symbol_1st: 'Si', $
		Symbol_2nd: 'Si', $
		Absorption: ['1','No','Yes'], $
		Temperature_factor: 1.0, $
		E_min:5000.0,$
		E_max:15000.0,$
		E_step:100.0,$
		shadow_file:'reflec.dat',$
		rc: ['1','No','Yes'] , $
		Mosaic: ['0','No','Yes'] , $
		RC_mode: ['1', 'LAUE: diffr beam','BRAGG: diffr beam [thin]', $
		  'BRAGG: diffr beam [thick]'] , $
		RC_energy: 8000., $
		Mosaic_fwhm: 0.1, $
		Thickness: 0.01, $
		Asymmetric_angle: 0.0, $
		Angular_range: 100.0, $
		Number_of_points: 200, $
		Sec_of_arc: ['0', 'Radians','Arc Sec'] , $
		Centered_curve: ['0','No','Yes'],$
		ionic_ask:['0','No','Yes'] }}
   END


  'XSH_CONIC':BEGIN
    help_text = [ ' ',$
   "This applications helps to create mesh surfaces ",$
   "from a conic defined starting from the focusing ",$
   "conditions."]
     titles=[ $
; conic
        'p [cm] ',$
	'q [cm]',$
	'grazing angle [mrad]',$
	'conic type',$
	'invert convexity',$
	'cylindrical symmetry',$
	'cyl axis [deg, from Y]',$
; mesh
	'Surface width (X) [cm]',$
	'Surface length (Y) [cm]',$
	'Number of points in X',$
	'Number of points in Y', $
	'Modify surface', $
; output
        'File name']
     flags = replicate('1',N_Elements(titles))
     parameters={ $
	p:3000.0,$
	q:1000.0,$
	theta:3.0, $
        type: ['2', $
              '(Undefined-0)', $
              'Spherical-1', $
              'Ellipsoidal-2', $
              '(Toroidal-3)', $
              'Paraboloid-4', $
              'Plane-5', $
              '(Undefined-6)', $
              'Hyperboloid-7', $
              '(Cone-8)', $
              '(Polynomial-9)'], $
        convex:['0','No','Yes'], $
        cyl:['0','No','Yes'], $
        cylAngle:0., $
        width:6.0, $ 
	length:300.0, $
	nx:10L, $
        ny:200L, $
        sag:['0',$ 
             'Do nothing', $
             'Replicate central meridional profile',$
             'Replicate central sagittal profile',$
             'Replicate central mer + add central sag',$
             'Fixed in sagittal + central meridional', $
             'Cone in sagittal (averaged at edges)+ central meridional', $
             'Cone in sagittal (tg at pole) + central meridional'], $
        file:'presurface.dat'  }
     out = {parameters:parameters, titles:titles, help_text:help_text,$
	flags:flags}
   END


ENDCASE
Return,out
END

