;+ 
;
; testnurbs1: test a simple spherical mesh:
;
;   i) creates an sphere mesh, writes it to a file, 
;   ii) reads it and compute a nurbs that passes through the grid points
;   iii) tests evaluated points, on the same grid
;   iv) tests evaluated points, on a larger interpolated grid
;-


;
; i) create a sphere mesh, writes it to a file (testsurf.dat)
;
print,'i) create a sphere mesh, writes it to a file (testsurf.dat)'
nx=10
ny=20
lx=100D0
ly=400D0
rr = 10d2 ; in cm
;
xx = MakeArray1(nx,-lx/2,lx/2,/Double)
yy = MakeArray1(ny,-ly/2,ly/2,/Double)
zz = DblArr(nx,ny)
FOR i=0L,nx-1 DO BEGIN
  FOR j=0L,ny-1 DO BEGIN
    zz[i,j]= -Sqrt(rr^2-xx[i]^2-yy[j]^2)
    zz[i,j]= zz[i,j]+rr
  ENDFOR
ENDFOR
surface,zz,xx,yy,title='SURFACE DATA GRID'
matr2presur,zz,xx,yy,File='testsurf.dat'

;
; ii) reads the file and compute a nurbs that passes through the grid points
;
pause
print,'ii) reads the file and compute a nurbs that passes through the grid points'
a=nrbconvsurf('testsurf.dat')
b=nrbgetknots(a,uu=uu,vv=vv)
help,/str,b
n1 = nrbstruct(a,b.uknots,b.vknots)
help,/str,n1
n2=nrbinterpcoefs(n1,uu,vv)
help,/str,n2

nrbplot,n2,30,30,iTools=0,title='n2 NURBS 30x30 interpolated grid'

;
; iii) tests evaluated points, on the same grid
;
pause
print,'iii) tests evaluated points, on the same grid'
print,'testing the same grid...'

nx  = n_elements(uu)
ny  = n_elements(vv)

for j=0L,ny-1 do begin
  for i=0L,nx-1 do begin
    c = nrbeval(n2,uu[i],vv[j])
    print,'  '
    print,i,j,c[2]-(rr-Sqrt(rr^2-c[0]^2-c[1]^2))
    print,i,j,c[2]-a[i,2,j]
  endfor
endfor


;
pause
print,'iv) tests evaluated points, on a larger interpolated grid'
nxx = 400 ; nx*10
nyy = 400 ; ny*10
help,nxx,nyy
c2=nrbeval(n2,makearray1(nxx,0,1,/double),makearray1(nyy,0,1,/double))
c2e = c2 ; exact value

; compute exact values
for j=0L,nyy-1 do begin
  for i=0L,nxx-1 do begin
    x1 = c2e[i,0,j]
    y1 = c2e[i,1,j]
    c2e[i,2,j] = rr-Sqrt(rr^2-x1^2-y1^2)
  endfor
endfor
; compute differences in z
c2e[*,2,*]=c2e[*,2,*]-c2[*,2,*]
nrbplot,c2e


END
