function myidlGrArrow::init
model=obj_new('idlgrmodel')
self.model=model
return, 1
end

function myidlGrArrow::get_model
return, self.model
end

pro myidlGrArrow::setProperty, x,y,z, color=color
if n_elements(color) eq 0 then color=[255,0,0]

vect=[x[1]-x[0], $
	y[1]-y[0], $
	z[1]-z[0]]
vectP1=[x[1]-x[0], $
	y[1]-y[0]]
vectP2=[x[1]-x[0]]


l=norm(vect)
lp1=norm(vectP1)
lp2=norm(vectP2)


if l eq 0 then return


alpha=acos(lp1/l)
if z[1] lt z[0] then alpha=-alpha
alpha=-alpha*180/!pi

if lp1 ne 0 then begin
beta=acos(lp2/lp1)
if y[1] lt y[0] then beta=-beta
if x[1] lt x[0] then beta=!pi-beta
beta=beta*180/!pi
endif else beta=0

;the arrow

larg=0.07*l
h=0.3*l
b=(1-0.3)*l
nb_cotte=9
s=[b+h,0,0]
da=(2*!dpi/nb_cotte)
point=fltarr(nb_cotte+1,3)
a=0
for p=0, nb_cotte-1 do begin
	point[p,*]=[b,larg*cos(a),larg*sin(a)]
	a=a+da
endfor
point[nb_cotte,*]=s
connex=intarr(4,nb_cotte)
for p=0, nb_cotte-2 do begin
	connex[*,p]=[ 3, p, p+1, nb_cotte]
end
connex[*,nb_cotte-1]=[3,nb_cotte-1,0,nb_cotte]

normal=obj_new('idlgrmodel',name='normal')
normal->add, obj_new('idlgrpolyline', [0,s[0]*8/10],[0,s[1]],[0,s[2]], $
						 Color=color)
normal->add, obj_new('idlgrpolygon', Point[*,0],Point[*,1],Point[*,2], $
						POLYGONS =connex, Color=color, /SHADING)

self.model->add, normal
axis=[0,0,1]
self.model->rotate, axis, beta
axis=[-sin(beta*!pi/180),cos(beta*!pi/180),0]
self.model->rotate, axis, alpha
self.model->translate, x[0], y[0], z[0]
end

pro myidlGrArrow::test
l=obj_new('idlgrlight',location=[0,0,100],type=1)
x_title=obj_new('idlgrtext','X')
y_title=obj_new('idlgrtext','Y')
z_title=obj_new('idlgrtext','Z')
axisX=obj_new('idlgraxis',direction=0,range=[0,1],color=[255,255,255],major=0,minor=0,title=x_title)
axisY=obj_new('idlgraxis',direction=1,range=[0,1],color=[255,255,255],major=0,minor=0,title=y_title)
axisZ=obj_new('idlgraxis',direction=2,range=[0,1],color=[255,255,255],major=0,minor=0,title=z_title)

view=obj_new('idlgrview',color=[100,100,100],PROJECTION=1)

model=obj_new('idlgrmodel')
view->add, model
model->add, axisX
model->add, axisY
model->add, axisZ
model->add, l
MODEL->ADD, SELF.MODEL



T=[[-0.53084921, 0.84744478, -0.0062375183, 0.00000000], $
     		[-0.38315753, -0.23343572, 0.89370150, 0.00000000], $
      		[0.75590548, 0.47680958, 0.44862318, 0.00000000], $
      		[0.00000000, 0.00000000, 0.00000000, 1.0000000]]
model->setProperty, transform=T

win=obj_new('idlgrwindow')

win->draw, view

end



pro myidlGrArrow__define
model=obj_new('idlgrmodel')
s={myidlGrArrow, model:model}
end
