PRO sysplot_x3d,XFACT=xfact,YFACT=yfact,ZFACT=zfact,SOURCEPLANE=src
;+
; NAME:
;	SYSPLOT_X3D
; PURPOSE:
;	to make a 3 dimensinal plot of some rays
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;
;	SYSPLOT_X3D
;
;	with that, the original SHADOW sysplot is spawned, then
;	the results (files SYSPLOT.STR and SYSPLOT.DAT) are read,
;	a new file called SYSPLOT.obj is prepared, which is an input
;	for the program x3d (from Mark Spychalla, spy@castlab.engr.wisc.edu)
;	Then the x3d program is spawned, which displays data
;	X3d is available by anonymous ftp from castlab.engr.wisc.edu
;
; INPUTS:
;	Nothing. Inputs are asked by the program.
; KEYWORD PARAMETERS:
;	SOURCEPLANE: if set to 1, then displays an square meaning the
;		source plane.
;	[XYZ]FACTOR: Scale factor from the real coordinates to the
;		coordinates displayed.
; OUTPUTS:
;	Starts sysplot and x3d (must be installed).
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	Create and remove files.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Just a prepares the file for x3d and calls it.
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, December 14 1994
;	97-09-30 srio@esrf.fr READ_ASCII renamed to RASCII
;	2009-11-05 renamed from sysplot to sysplot_x3d
;-

on_error,2
;
; runs shadow's sysplot
;
print,'SYSPLOT: Running sysplot: Please use 3d plot...'
spawn,'sysplot'
;
; stores data created by sysplot
;
print,'SYSPLOT: Reading data...'
nrays = 0L
openr,unit,'SYSPLOT.STR',/get_lun
readf,unit,tmp
readf,unit,tmp
readf,unit,nrays,tmp
free_lun,unit

a = rascii('SYSPLOT.DAT')

;
; coordinate change to fit data in the x3d display limits
;
xmin = min(a(0,*),max=xmax)
ymin = min(a(1,*),max=ymax)
zmin = min(a(2,*),max=zmax)

if not(keyword_set(yfact)) then yfact = 2000./(ymax-ymin)
if not(keyword_set(zfact)) then zfact = 500./(zmax-zmin)
if not(keyword_set(xfact)) then xfact = 500./(xmax-xmin)
print,'SYSPLOT: [xyz]fact: ',xfact,yfact,zfact
a(0,*) = a(0,*)*xfact - 250.
a(1,*) = a(1,*)*yfact - 1000.
a(2,*) = a(2,*)*zfact - 250.

npoints = n_elements(a(0,*))
nsegments = ((npoints/nrays) - 1)*nrays
print,'SYSPLOT: Rays used: ',nrays
print,'SYSPLOT: Points used: ',npoints
print,'SYSPLOT: Segments used: ',nsegments

;
; creates the SYSPLOT.obj file for x3d
;
openw,unit,'SYSPLOT.obj',/get_lun
printf,unit,'# x3d file created by sysplot.pro (IDL shadow application)
printf,unit,' '

printf,unit,'# number of colors used in object'
printf,unit,' '
printf,unit,'6'

printf,unit,'#  colors used in object (color number red green blue)'
printf,unit,' '
printf,unit,'0   0 255 0'
printf,unit,'1   0 0 255'
printf,unit,'2   255 0 0'
printf,unit,'3   255 255 255'
printf,unit,'4   128 0 255'
printf,unit,'5   255 128 0'

printf,unit,'# number of points used in object'
printf,unit,' '
if keyword_set(src) then printf,unit,npoints+4 else printf,unit,npoints
printf,unit,' '

printf,unit,'# points used in object (point number x y z)
printf,unit,' '
for i=0L,n_elements(a(0,*))-1 do printf,unit,i,a(*,i)
if keyword_set(src) then begin
  printf,unit,i+1,-500.,-1000.,-500.
  printf,unit,i+2,-500.,-1000.,0.
  printf,unit,i+3,0.,-1000.,0.
  printf,unit,i+4,0.,-1000.,-500.
endif
printf,unit,' '

printf,unit,'# number segments used in object'
printf,unit,' '
if not(keyword_set(src)) then printf,unit,nsegments else $
   printf,unit,nsegments+4

printf,unit,'segments used in object (segment number color p q)'
printf,unit,' '
iacum = 0L
jacum = 0
tmp = nsegments/nrays
for i=0L,(nsegments/tmp)-1 do begin
  for j=0,tmp-1 do begin
    printf,unit,iacum,0,jacum,jacum+1
    iacum = iacum+1
    jacum = jacum+1
  endfor
  jacum = jacum+1
endfor
if keyword_set(src) then begin
  printf,unit,iacum+1,1,jacum,jacum+1
  printf,unit,iacum+2,1,jacum+1,jacum+2
  printf,unit,iacum+3,1,jacum+2,jacum+3
  printf,unit,iacum+4,1,jacum+3,jacum
endif

printf,unit,' ' 
printf,unit,'# number of polygons used in object'
printf,unit,' ' 
printf,unit,'0' 

free_lun,unit

;
; spawn x3d and clean useless files
;
print,'SYSPLOT: Calling x3d...'
print,'SYSPLOT: Type M(enu) or Q(uit).'
spawn,'x3d SYSPLOT.obj'
command = '/bin/rm SYSPLOT.obj'
print,command  &  spawn,command

end

