;+
; NAME:
;       blv_module_control
;
; PURPOSE:
;       This function creates and returns a widget base with all the widget 
;	element necessary to control the property of the modules.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;	wBase=blv_module_control, pInfo
;
; INPUTS:
;       pInfo: A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-


;
;===============================================================================
;
pro blv_module_control_close, pInfo


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_module_control_close: error caught: '+!error_state.msg)
   RETURN
ENDIF


;purpose: closes the widget
	temp=(*pInfo).wid.wModule
	(*pInfo).wid.wModule=(*pInfo).wid.tbl
	blv_no_show_element, pInfo
	widget_control, temp, /destroy
end

;
;===============================================================================
;
pro blv_module_control_select_module_event, event
; purpose: switch from modules 


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_module_control_select_module_event: error caught: '+ $
		!error_state.msg)
   RETURN
ENDIF


widget_control, event.id, get_value=button
widget_control, event.top, get_uvalue=info

nb_element=(*info.pInfo).data.system->count()
if nb_element eq 0 then return
posi=(*info.pInfo).data.position
case button of
	'<< Previous': begin
		if posi EQ -1 then posi=nb_element-1 else posi=posi-1
		end
	'Next >>': begin
		if posi EQ nb_element-1 then posi=-1 else posi=posi+1
		end
	else: Message,'CASE not found: '+button   ;nothing
endcase

(*info.pInfo).data.position=posi
blv_change_selected_module, info.pInfo
widget_control, (*info.pInfoModule).wSelectedModule, set_value=(*info.pInfo).data.position+1

blv_draw_system,info.pInfo
end

;
;===============================================================================
;
pro blv_module_control_print_property, info
;purpose: change all the property of the widget base function to the current module

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_module_control_print_property: error caught: '+!error_state.msg)
   RETURN
ENDIF


if (*info.pInfo).data.position ne -1 then begin
	module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
	module->getProperty, show_axis=show_axis, $
					show_normal=show_normal, $
					show_symbol=show_element, $
					show_axes_element=show_axes_element, $
					transparen=trans, $
 					log=log, $
 					normal_scale=normal_scale, $
 					axes_element_scale=axes_element_scale, $
 					dimension_scale=dim_scale, $
 					distance_scale=dist_scale, $
 					type_name=type_name

	widget_control, (*info.pInfoModule).wElement, set_button=abs(show_element-1)
	widget_control, (*info.pInfoModule).wOEgroup, set_value=abs(trans-1)
	widget_control, (*info.pInfoModule).wOpticalAxes, set_button=abs(show_axis-1)
	widget_control, (*info.pInfoModule).wNormal, set_button=abs(show_normal-1)
	widget_control, (*info.pInfoModule).wAxesElement, set_button=abs(show_axes_element-1)
	widget_control, (*info.pInfoModule).wNormalScale, set_value=normal_scale
	widget_control, (*info.pInfoModule).wOeAxesScale, set_value=axes_element_scale
	widget_control, (*info.pInfoModule).wDistance, set_value=dist_scale
	widget_control, (*info.pInfoModule).wDimension, set_value=dim_scale

	case type_name of
		'Rectangle':widget_control, (*info.pInfoModule).wTypeName, set_dropList_select=0
		'Ellipse':widget_control, (*info.pInfoModule).wTypeName, set_dropList_select=1
		'Ellipse with a hole':widget_control, (*info.pInfoModule).wTypeName, set_dropList_select=2
		'Infinite surface':widget_control, (*info.pInfoModule).wTypeName, set_dropList_select=3
		'External (VRML)':widget_control, (*info.pInfoModule).wTypeName, set_dropList_select=4
		else: return
	endcase
	if (*info.pInfo).wid.wPlanes ne (*info.pInfo).wid.tbl then begin
		blv_planes_control_print_property, info
	endif
endif
end

;
;===============================================================================
;
pro blv_module_control_flipShow_event, event
; purpose: change the binary propertys of type Show/Hide


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_module_control_flipShow_event: error caught: '+!error_state.msg)
   RETURN
ENDIF



widget_control, event.id, get_uvalue=button
widget_control, event.top, get_uvalue=info
if (*info.pInfo).data.position eq -1 then return
module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
case button of
	'optical element':begin
	 	module->flip, /show_symbol
		end
	'optical axes':begin
	 	module->flip, /show_axis
		end
	'O.E. normal': begin
		module->flip, /show_normal
		end
	'O.E. axes': begin
		module->flip, /show_axes_element
		end

	else: return
endcase
module->trace
blv_draw_system, info.pInfo
if (*info.pInfo).wid.wPlanes ne (*info.pInfo).wid.tbl then begin
	widget_control,(*info.pInfo).wid.wPlanes, get_uvalue=infoBis
	blv_planes_control_print_property, infoBis
endif
end
;
;===============================================================================
;
pro blv_module_control_event, event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_module_control_event: error caught: '+!error_state.msg)
   RETURN
ENDIF



widget_control, event.top, get_uvalue=info

IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN BEGIN
	blv_module_control_close, info.pInfo
	return
ENDIF

widget_control, event.id, get_uValue=button
CASE button OF
	'selectedModule':begin
				widget_control,(*info.pInfoModule).wSelectedModule, get_value=index
				index=index-1
				nb_module=(*info.pInfo).data.system->count()
				if index gt nb_module-1 or index lt 0 then begin
					widget_control,(*info.pInfoModule).wSelectedModule, $
						set_value=(*info.pInfo).data.position+1
					return
				endif
				(*info.pInfo).data.position=index
				blv_change_selected_module, info.pInfo
				blv_draw_system, info.pInfo
				end
	'normalScale':begin
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

				widget_control, (*info.pInfoModule).wNormalScale, get_value=scale
				module->setProperty, normal_scale=scale
				(*info.pInfo).data.system->trace
				blv_draw_system, info.pInfo
				end
	'oeAxesScale':begin
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

				widget_control, (*info.pInfoModule).wOeAxesScale, get_value=scale
				Module->setProperty, axes_element_scale=scale
				(*info.pInfo).data.system->trace
				blv_draw_system, info.pInfo
				end
	'wOEGroup':begin
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

				widget_control, (*info.pInfoModule).wOEGroup, get_value=trans
				module->setProperty, transparen=abs(trans-1)
				(*info.pInfo).data.system->trace
				blv_draw_system, info.pInfo
				end
	'dimScale':begin
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

				widget_control, (*info.pInfoModule).wDimension, get_value=dimScale
				module->setProperty, dimension_scale=dimScale
				(*info.pInfo).data.system->trace
				blv_draw_system, info.pInfo
				end
	'distScale':begin
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

				widget_control, (*info.pInfoModule).wDistance, get_value=distScale
				module->setProperty, distance_scale=distScale
				(*info.pInfo).data.system->trace
				blv_draw_system, info.pInfo
				end

	'blv_module_control_done_event': BEGIN
				;purpose: calls a procedure to close the widget
				widget_control, event.top, get_uvalue=info
				blv_module_control_close, info.pInfo
				END

	'blv_module_control_delete_event': BEGIN
				;purpose: calls a procedure to delete the current module
				widget_control, event.top, get_uvalue=info
				blv_del_optical_module, info.pInfo
				blv_draw_system, info.pInfo
				END
	'blv_module_control_delete_all_event': BEGIN
				;purpose: calls a procedure to delete all the modules
				widget_control, event.top, get_uvalue=info
				blv_del_all_optical_module, info.pInfo
				blv_draw_system, info.pInfo
				END
	'blv_module_control_add_event': BEGIN
				;purpose: calls a procedure to add a the module and control the staut bar
				widget_control, event.top, get_uvalue=info
				widget_control, (*info.pInfo).wid.statut, set_value='Waiting...'
				dim=blv_module_def_parameter(event.top)
				if dim.ok eq 0 then begin
					widget_control, (*info.pInfo).wid.statut, set_value='Ready.'
					return
				endif
				blv_add_optical_module, dim, info.pInfo
				blv_draw_system, info.pInfo
				widget_control, (*info.pInfo).wid.statut, set_value='Ready.'
				END

	'blv_module_control_color_optical_axes': BEGIN
				;purpose: the 4 next procedure control the color of several element
				widget_control, event.top, get_uvalue=info
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
				module->getProperty, optical_axes_color=color
				dim=Get_RGB((*info.pInfoModule).wBase, rgb=color)
				if dim.ok eq 1 then module->setProperty, optical_axes_color=dim.rgb
				module->trace
				blv_draw_system, info.pInfo
				END
	'blv_module_control_color_normal': BEGIN
				widget_control, event.top, get_uvalue=info
		
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
				
				module->getProperty, normal_color=color
				dim=Get_RGB((*info.pInfoModule).wBase, rgb=color)
				if dim.ok eq 1 then module->setProperty, normal_color=dim.rgb
				module->trace
				blv_draw_system, info.pInfo
				END
	'blv_module_control_color_oe_axes': BEGIN
				widget_control, event.top, get_uvalue=info
		
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
				
				module->getProperty, axes_element_color=color
				dim=Get_RGB((*info.pInfoModule).wBase, rgb=color)
				if dim.ok eq 1 then module->setProperty, axes_element_color=dim.rgb
				module->trace
				blv_draw_system, info.pInfo
				END

	'blv_module_control_color_optical_element': BEGIN
				widget_control, event.top, get_uvalue=info
		
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
				
				module->getProperty, optical_element_color=color
				dim=Get_RGB((*info.pInfoModule).wBase, rgb=color)
				if dim.ok eq 1 then module->setProperty, optical_element_color=dim.rgb
				module->trace
				blv_draw_system, info.pInfo
				END




	'blv_module_control_typeName_event': BEGIN
				;purpose: change the type of the current module
				widget_control, event.top, get_uvalue=info

				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

				module->getProperty, rlen1=rlen1, $
					rlen2=rlen2, $
					rwidx1=rwidx1, $
					rwidx2=rwidx2, $
					prof=prof

				index=event.index
				case index of
					0: typeName='Rectangle'
					1: typeName='Ellipse'
					2: typeName='Ellipse with a hole'
					3: typeName='Infinite surface'
					4: typeName='External (VRML)'
				endcase
				
				newSymbol=blv_create_optical_module_symbol(typeName, rlen1, rlen2, rwidx1, rwidx2, $
					prof, mesh_file=mesh_file)
				
				module->setProperty,type_name=typeName,$
								symbol=newSymbol

				if n_elements(mesh_file) ne 0 then module->setProperty, mesh_file=mesh_file

				module->trace
				blv_draw_system, info.pInfo
				END



	'blv_module_control_change_geometry_event': BEGIN
				;purpose: change the geometry of the current module
				widget_control, event.top, get_uvalue=info
				
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

				module->getProperty, rlen1=rlen1, $
					rlen2=rlen2, $
					rwidx1=rwidx1, $
					rwidx2=rwidx2, $
					prof=prof, $
					type_name=typeName, $
					mesh_file=mesh_file
				var={rlen1:rlen1, rlen2:rlen2 , rwidx1:rwidx1, rwidx2:rwidx2, deep:prof}
				CASE typeName OF
				'Rectangle': BEGIN
						titles=['Half-length +Y [cm]','Half-length +Y [cm]', $
							'Half-width +X [cm]','Half-length -X [cm]','Thickness [cm]']
						flags=['1','1','1','1','1']
						END
				'Ellipse': BEGIN
						 titles=['','External major axis +Y [cm]', $
							'','External minor axis +X [cm]', 'Thickness [cm]']
						flags=['0','1','0','1','1']
						END
				'Ellipse with a hole': BEGIN
						titles=['External major axis +Y [cm]','Hole half-axis +Y [cm]', $
                                                        'External minor axis +X [cm]','Hole half-axis +X [cm]', $
							'Thickness [cm]']
						flags=['1','1','1','1','1']
						END
				'Infinite surface': BEGIN
						titles=['Half-length +Y [cm]','', $
							'Half-width +X [cm]','','Thickness [cm]']
						flags=['1','0','1','0','1']
						END
				'External (VRML)': BEGIN
						titles=['Half-length +Y [cm]','Half-length +Y [cm]', $
							'Half-width +X [cm]','Half-length -X [cm]','Thickness [cm]']
						flags=['1','1','1','1','1']
						END
				else: Message,'CASE not found: '+typeName
				ENDCASE

				xScrMenu, var, wTitle='OE Geometry',/notype,group=(*info.pInfoModule).wBase, $
					action=action, Dialog_Parent=event.top, titles=titles, Flags=flags
				
				if action eq 'DONT' then return
				
				module->setProperty, rlen1=var.rlen1, $
					rlen2=var.rlen2, $
					rwidx1=var.rwidx1, $
					rwidx2=var.rwidx2, $
					prof=var.deep

;				module->getProperty, rlen1=rlen1, $
;					rlen2=rlen2, $
;					rwidx1=rwidx1, $
;					rwidx2=rwidx2, $
;					prof=deep


				if mesh_file eq 'External (VRML)' then begin
					newSymbol=blv_create_optical_module_symbol(typeName, rlen1, rwidx1, $
						rlen2, rwidx2, deep, mesh_file=mesh_file)
					module->setProperty, symbol=newSymbol
				endif

				module->trace
				blv_draw_system, info.pInfo
				;
				; this part gas been added by srio@esrf.fr on 19/10/2001 to get the image
				; refreshed with the new dimensions. I really do not know why the image
				; is not refreshed if I do not use this piece of code.

				case typeName of
				  'Rectangle': index=0
				  'Ellipse': index=1
				  'Ellipse with a hole': index=2
				  'Infinite surface': index=3
				  'External (VRML)': index=4
				endcase
				blv_module_control_event,{ WIDGET_DROPLIST, id:(*info.pInfoModule).wTypeName, $
					top:event.top, handler:event.handler, index:index}
				


				END
	'blv_module_control_change_position_event': BEGIN
				; purpose: change the position of the current module
				widget_control, event.top, get_uvalue=info

				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

				module->getProperty, t_source=t_source, $
					t_image=t_image, $
					t_incidence=t_incidence, $
					t_reflection=t_reflection, $
					alpha=alpha
				var={t_source:t_source, t_image:t_image, t_incidence:t_incidence, $
					t_reflection:t_reflection, alpha:alpha}
				titles=blv_var_title(['t_source','t_image','t_incidence','t_reflection','alpha'])
				xScrMenu, var, wTitle='OE Position',/notype,group=event.top, action=action, $
					Dialog_Parent=event.top, Titles=titles

				if action eq 'DONT' then return

				module->setProperty, t_source=var.t_source, $
					t_image=var.t_image, $
					t_incidence=var.t_incidence, $
					t_reflection=var.t_reflection, $
					alpha=var.alpha

				(*info.pInfo).data.system->trace
				blv_draw_system, info.pInfo
				END


	'blv_module_control_images_event': BEGIN
				;purpose: call a procedure to control the planes of the current module
				widget_control, event.top, get_uvalue=info
				if (*info.pInfo).wid.wPlanes eq (*info.pInfo).wid.tbl then begin
				(*info.pInfo).wid.wPlanes=blv_planes_control(info.pInfo)
				blv_planes_control_print_property, info
				endif
				END


	'blv_module_control_planes_event': BEGIN
				;purpose: control the show/hide planes option of the current module
				widget_control, event.id, get_value=button
				widget_control, event.top, get_uvalue=info
				
				if (*info.pInfo).data.position eq -1 then return
				module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
				
				case button of
					'Show':begin
						module->setProperty, show_plane_added=0
						end
					'Hide':begin
						module->setProperty, show_plane_added=1
						end
					else: Message,'Case not found: '+button
				endcase
				if (*info.pInfo).wid.wPlanes ne (*info.pInfo).wid.tbl then begin
					blv_planes_control_print_property, info
				endif
				
				module->trace
				blv_draw_system, info.pInfo
				END


	else: Message,'Case not found: '+uValue
ENDCASE
END




; srio ;*********************************************
; srio ;purpose: calls a procedure to close the widget and apply current property on the current module
; srio pro blv_module_control_apply_event, event
; srio widget_control, event.top, get_uvalue=info
; srio ;selected module
; srio widget_control,(*info.pInfoModule).wSelectedModule, get_value=index
; srio index=index-1
; srio nb_module=(*info.pInfo).data.system->count()
; srio if index gt nb_module-1 or index lt 0 then begin
; srio 	widget_control,(*info.pInfoModule).wSelectedModule, set_value=(*info.pInfo).data.position+1
; srio 	return
; srio endif
; srio (*info.pInfo).data.position=index
; srio 
; srio blv_change_selected_module, info.pInfo
; srio blv_draw_system, info.pInfo
; srio end





;srio ;********************************************
;srio ;purpose: reset the value of a selected scale to 1.
;srio pro blv_module_control_resetScale_event, event
;srio widget_control, event.id, get_uvalue=button
;srio widget_control, event.top, get_uvalue=info
;srio 
;srio if (*info.pInfo).data.position eq -1 then return
;srio module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
;srio 
;srio case button of
;srio 	'dimension':begin
;srio 				widget_control, (*info.pInfomodule).wDimension, set_value=1.
;srio 				widget_control, (*info.pInfomodule).wDimension, get_value=dimScale
;srio 				module->setProperty, dimension_scale=dimScale
;srio 				(*info.pInfo).data.system->trace
;srio 				end
;srio 
;srio 
;srio 	'distance':begin
;srio 				widget_control, (*info.pInfoModule).wDistance, set_value=1.
;srio 				widget_control, (*info.pInfoModule).wDistance, get_value=distScale
;srio 				module->setProperty, distance_scale=distScale
;srio 				(*info.pInfo).data.system->trace
;srio 				end
;srio endcase
;srio blv_draw_system, info.pInfo
;srio end



;
;===============================================================================
;
function blv_module_control, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_module_control: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


	wBase=widget_base(GROUP_LEADER=(*pInfo).wid.tbl,title='Optical Module Controls',/col, $
				/TLB_KILL_REQUEST_EVENTS, event_pro='blv_module_control_event', /floating)
		wButton=widget_base(wBase,/row)
			wDone=widget_button(wButton, value='Dismiss',UValue='blv_module_control_done_event')
;			wApply=widget_button(wButton, value='Apply', event_pro='blv_module_control_apply_event')
		wInfo=widget_base(wBase, /col,/frame)
			wTemp=widget_base(wInfo, /col,/align_center,/base_align_right)
			wNbMod=widget_base(wTemp,/row,/base_align_center)
				wTitle=widget_label(wNbMod,value='Number of optical modules : ')
				wNbModule=widget_label(wNbMod,value=string((*pInfo).data.system->count()),/align_right)
			wSelectedMod=widget_base(wTemp,/row,/base_align_center)
				wSelectedModule=cw_field(wSelectedMod,title='Selected Optical Module : ',$
				/Integer, uValue='selectedModule', $
			 	value=(*pInfo).data.position+1, xsize=5,/return_event)
			wEdit=widget_base(wInfo,/row)
				wBack=widget_button(wEdit, value='<< Previous', event_pro='blv_module_control_select_module_event')
				wNext=widget_button(wEdit, value='Next >>', event_pro='blv_module_control_select_module_event')
				wDelete=widget_button(wEdit, value='Delete', UValue='blv_module_control_delete_event')
				wDeleteAll=widget_button(wEdit, value='Delete All', UValue='blv_module_control_delete_all_event')
				wAdd=widget_button(wEdit, value='Add...', UValue='blv_module_control_add_event')

		wAttribute=widget_base(wBase, /col,/frame,/align_left)
		wShowBin = WIDGET_BASE(wAttribute, $
                    /column)
			wtempBase=widget_base(wShowBin,/row,/align_right)
				radioOE=['Frame', $
		 			 'Opaque' ]
				wtextOE=widget_label(wtempBase, value='O.E.    ')
				wtempCheck=widget_base(wtempBase,/NONEXCLUSIVE)
				wElement=WIDGET_BUTTON(wtempCheck, $
                        VALUE='Show', $
                        uvalue='optical element', $
                        EVENT_PRO='blv_module_control_flipShow_event')
				wOEChoice=widget_base(wtempBase,/col)
    				wOEGroup=CW_BGROUP(wOeChoice, $
            	            radioOe, $
                	        /row,/RETURN_INDEX, /EXCLUSIVE, $
                    	    /NO_RELEASE, uValue='wOEGroup')
			wColor=widget_button(wtempBase, value='Color...', $
				UValue='blv_module_control_color_optical_element')

			wtempBase=widget_base(wShowBin,/row,/align_right)
			wTitle=widget_label(wtempBase,value='Optical Axes    ')
			wtempCheck=widget_base(wtempBase,/NONEXCLUSIVE)
        	wOpticalAxes = WIDGET_BUTTON(wtempCheck, $
                        VALUE='Show', $
                        uvalue='optical axes', $
                        EVENT_PRO='blv_module_control_flipShow_event')
			wColor=widget_button(wtempBase, value='Color...', $
				UValue='blv_module_control_color_optical_axes')

			wtempBase=widget_base(wShowBin,/row,/align_right)
			wTitle=widget_label(wtempBase,value='Screen/Slit Plane    ')
			wShowPlanes = WIDGET_BUTTON(wtempBase, VALUE='Show', $
                          UValue='blv_module_control_planes_event')
            wHidePlanes = WIDGET_BUTTON(wtempBase, VALUE='Hide', $
                          UValue='blv_module_control_planes_event')
			wImages=widget_button(wtempBase, value='Modify...', $
				UValue='blv_module_control_images_event')

			wtempBase=widget_base(wShowBin,/row,/align_right)
			wTitle=widget_label(wtempBase,value='O.E. Normal    ')
			wtempCheck=widget_base(wtempBase,/NONEXCLUSIVE)
			wNormal = WIDGET_BUTTON(wtempCheck, $
                        VALUE='Show', $
                        uvalue='O.E. normal', $
                        EVENT_PRO='blv_module_control_flipShow_event')
			(*pInfo).data.system->getProperty, normal_scale=value
		;	wLabel=widget_label(wTempBase, value='Scale : ')
			wNormalScale=CW_Field(wtempBase,$
									value=value, title='Scale : ', uvalue='normalScale', xsize=4, /return_event)
			wColor=widget_button(wtempBase, value='Color...', $
				UValue='blv_module_control_color_normal')

			wtempBase=widget_base(wShowBin,/row,/align_right)
			wTitle=widget_label(wtempBase,value='O.E. Axes    ')
			wtempCheck=widget_base(wtempBase,/NONEXCLUSIVE)
			wAxesElement = WIDGET_BUTTON(wtempCheck, $
                        VALUE='Show', $
                        uvalue='O.E. axes', $
                        EVENT_PRO='blv_module_control_flipShow_event')

		;	wLabel=widget_label(wTempBase, value='Scale : ')
			wOeAxesScale=CW_Field(wtempBase, title='Scale : ', $
							value=value, uvalue='oeAxesScale', xsize=4, /return_event)
			wColor=widget_button(wtempBase, value='Color...', $
				UValue='blv_module_control_color_oe_axes')


			wScale=widget_base(wAttribute,/col)
			wScaleDim=widget_base(wScale,/row,/ALIGN_RIGHT)
				wtitleDim=widget_label(wScaleDim, value='Dimension Scale : ')
				wDimension=CW_FSlider1(wScaleDim, minimum=0.001,maximum=4.0, uvalue='dimScale',$
					/edit,/reset,Value=1.0,XSize=180)
;				wreset=widget_button(wScaleDim,value='Reset',uvalue='dimension', $
;							event_pro='blv_module_control_resetScale_event')


			wScaleDis=widget_base(wScale,/row,/ALIGN_RIGHT)
				wtitleDis=widget_label(wScaleDis, value='Distance Scale : ')
				wDistance=CW_FSlider1(wScaleDis, minimum=0.001,maximum=4.0, $
					uvalue='distScale',/edit,/reset,Value=1.0,XSize=180)
;				wreset=widget_button(wScaleDis,value='Reset',uvalue='distance', $
;							event_pro='blv_module_control_resetScale_event')

		wParameter=widget_base(wBase, /col,/frame)
			wGeoBase=widget_base(wParameter, /row)
				list_type_name=['Rectangle','Ellipse','Ellipse with a hole','Infinite surface',$
					'External (VRML)']
				wTypeName=widget_droplist(wGeoBase, title='Shape :', value=list_type_name, $
					UValue='blv_module_control_typeName_event')
				wGeometry=widget_button(wGeoBase, value='Geometry...', $
					UValue='blv_module_control_change_geometry_event')
				wposition=widget_button(wGeoBase, value='Position...', $
					UValue='blv_module_control_change_position_event')


pInfoModule=ptr_new({wBase:wBase, $
				wNbModule:wNbModule, $
				wSelectedModule:wSelectedModule, $
				wElement:wElement, $
				wOEGroup:wOEGroup, $
				wOpticalAxes:wOpticalAxes, $
				wNormal:wNormal, $
				wAxesElement:wAxesElement, $
				wNormalScale:wNormalScale, $
				wOeAxesScale:wOeAxesScale, $
				wDimension:wDimension, $
				wDistance:wDistance, $
				wTypeName:wTypeName $
			 	})

info={pInfoModule:pInfoModule, pInfo:pInfo}

widget_control, wBase, set_uValue=info
widget_control, wBase, /realize
blv_module_control_print_property, info
xmanager, 'blv_module_control', wBase, /no_block

return, wBase
end
