FUNCTION div_grid_radial,maxAperture,theta,npoints,FILE=file

;+
; NAME:
;	DIV_GRID_RADIAL
;
; PURPOSE:
;       This function returns the director cosines ("velocity vector")
;	of an inclined line. 
;
; CATEGORY:
;	SHADOW
;
; CALLING SEQUENCE:
;       v = Div_Grid_Radial(maxAperture,theta,nPoints)
;
; INPUTS:
;       
;	maxAperture: The semi-aperture angle seen by the stick [rad]
;	theta: the inclination angle [rad] measured respect to X
;	nPoints: The number of points over the radius
;
; KEYWORD PARAMETERS
;	File: a string cointaining a file name where to write
;		(optionally) the data. The file type is SHADOW binary.
;	Group: The widget ID of the caller. 
;
; OUTPUTS:
;       This function return the array v(3,npoints) with vx, vy and vz
;	in the columns 0,1 and 2, respectively.
;
; PROCEDURE:
;       
;       Easy.
;
; EXAMPLE:
;	v=Div_Grid_Radial(1.0D0,1.0D0,100) &  Plot,v[0,*],v[2,*]
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.fr), 99-12-23
;
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'DIV_GRID_RADIAL: error caught: '+!error_state.msg)
   Catch, /Cancel
   On_Error,2
   RETURN,0
ENDIF

;
;
IF N_Elements(maxAperture) EQ 0 THEN maxAperture  = 0.1D0 ; rad
IF N_Elements(theta) EQ 0 THEN theta  = 225.0D0*!dpi/180.0 ; rad
IF N_Elements(npoints) EQ 0 THEN npoints = 100L

mygrid = (DIndGen(npoints)/(npoints-1))*maxAperture

vx = mygrid*cos(theta)
vz = mygrid*sin(theta)
vy = Sqrt( ( (vx*vx+vz*vz)*(-1.0D0)+1.0D0 )>0 )
;vy = Replicate(1.0D0,nPoints)
;modv = Sqrt(vx*vx+vy*vy+vz*vz)
;vx = vx/modv
;vy = vy/modv
;vz = vz/modv
v = make_set(vx,vy,vz)
IF Keyword_Set(file) THEN WriteSh,file,v,[4,5,6]
RETURN,v
end

